/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Dscp bit config
 */
public final class DscpValue implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "DscpValue";

    private java.lang.Long dscpValue;

    private final java.lang.String indicatorType = "DscpValue";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DscpValue() {
    }

    protected DscpValue(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * A DSCP value is allocated to indicate the existence of INT header. It takes
     * effects only when the INT indicator mode is DSCP_VALUE. The user should
     * guarantee that the given DSCP value is specifically allocated for INT. format:
     * int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDscpValue() {
        return this.dscpValue;
    }

    /**
     * A DSCP value is allocated to indicate the existence of INT header. It takes
     * effects only when the INT indicator mode is DSCP_VALUE. The user should
     * guarantee that the given DSCP value is specifically allocated for INT. format:
     * int32
     *
     * @param dscpValue New value for the property.
     */
    public void setDscpValue(java.lang.Long dscpValue) {
        this.dscpValue = dscpValue;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.DscpIndicator#INDICATOR_TYPE_BIT}</li> <li> {@link
     * com.vmware.nsx_policy.model.DscpIndicator#INDICATOR_TYPE_VALUE}</li> </ul> The
     * method for indicating the existence of INT header.
     * The value of this property is automatically populated to {@code "DscpValue"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIndicatorType() {
        return this.indicatorType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.dscpValue;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dscp_value",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dscpValue, this._getType().getField("dscp_value")));
        structValue.setField("indicator_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.indicatorType, this._getType().getField("indicator_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.dscpValue;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.dscpValue.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DscpValue _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DscpValue(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DscpValue _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DscpValue(structValue);
    }

    /**
     * Builder class for {@link DscpValue}.
     */
    public static final class Builder {
        private java.lang.Long dscpValue;

        /**
         * Constructor with parameters for the required properties of
         * {@link DscpValue}.
         */
        public Builder() {
        }

        /**
         * A DSCP value is allocated to indicate the existence of INT header. It takes
         * effects only when the INT indicator mode is DSCP_VALUE. The user should
         * guarantee that the given DSCP value is specifically allocated for INT. format:
         * int32
         *
         * @param dscpValue New value for the property.
         */
        public Builder setDscpValue(java.lang.Long dscpValue) {
            this.dscpValue = dscpValue;
            return this;
        }

        public DscpValue build() {
            DscpValue result = new DscpValue();
            result.setDscpValue(this.dscpValue);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dscp_value", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dscp_value",
                                                                                "dscpValue",
                                                                                "getDscpValue",
                                                                                "setDscpValue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("indicator_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("indicator_type",
                                                                                "indicatorType",
                                                                                "getIndicatorType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.dscp_value",
                                                            fields,
                                                            com.vmware.nsx_policy.model.DscpValue.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "indicator_type",
                                                            "DscpValue");
    }
}

