/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * The traffic_name specifies the infrastructure traffic type and it must be one of
 * the following system-defined types: FAULT_TOLERANCE is traffic for failover and
 * recovery. HBR is traffic for Host based replication. ISCSI is traffic for
 * Internet Small Computer System Interface. MANAGEMENT is traffic for host
 * management. NFS is traffic related to file transfer in network file system. VDP
 * is traffic for vSphere data protection. VIRTUAL_MACHINE is traffic generated by
 * virtual machines. VMOTION is traffic for computing resource migration. VSAN is
 * traffic generated by virtual storage area network. The dynamic_res_pool_name
 * provides a name for the resource pool. It can be any arbitrary string. Either
 * traffic_name or dynamic_res_pool_name must be set. If both are specified or
 * omitted, an error will be returned.
 */
public final class HostInfraTrafficType implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String TRAFFIC_NAME_FAULT_TOLERANCE = "FAULT_TOLERANCE";

    public static final java.lang.String TRAFFIC_NAME_HBR = "HBR";

    public static final java.lang.String TRAFFIC_NAME_ISCSI = "ISCSI";

    public static final java.lang.String TRAFFIC_NAME_MANAGEMENT = "MANAGEMENT";

    public static final java.lang.String TRAFFIC_NAME_NFS = "NFS";

    public static final java.lang.String TRAFFIC_NAME_VDP = "VDP";

    public static final java.lang.String TRAFFIC_NAME_VIRTUAL_MACHINE = "VIRTUAL_MACHINE";

    public static final java.lang.String TRAFFIC_NAME_VMOTION = "VMOTION";

    public static final java.lang.String TRAFFIC_NAME_VSAN = "VSAN";

    private java.lang.String dynamicResPoolName;

    private java.lang.String trafficName;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public HostInfraTrafficType() {
    }

    protected HostInfraTrafficType(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Dynamic resource pool traffic name
     *
     * @return The current value of the property.
     */
    public java.lang.String getDynamicResPoolName() {
        return this.dynamicResPoolName;
    }

    /**
     * Dynamic resource pool traffic name
     *
     * @param dynamicResPoolName New value for the property.
     */
    public void setDynamicResPoolName(java.lang.String dynamicResPoolName) {
        this.dynamicResPoolName = dynamicResPoolName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_FAULT_TOLERANCE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_HBR}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_ISCSI}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_MANAGEMENT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_NFS}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VDP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VMOTION}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VSAN}</li>
     * </ul> Traffic types
     *
     * @return The current value of the property.
     */
    public java.lang.String getTrafficName() {
        return this.trafficName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_FAULT_TOLERANCE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_HBR}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_ISCSI}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_MANAGEMENT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_NFS}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VDP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VMOTION}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VSAN}</li>
     * </ul> Traffic types
     *
     * @param trafficName New value for the property.
     */
    public void setTrafficName(java.lang.String trafficName) {
        this.trafficName = trafficName;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.hostInfraTrafficType;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dynamic_res_pool_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dynamicResPoolName, this._getType().getField("dynamic_res_pool_name")));
        structValue.setField("traffic_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.trafficName, this._getType().getField("traffic_name")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.hostInfraTrafficType;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.hostInfraTrafficType.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static HostInfraTrafficType _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new HostInfraTrafficType(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static HostInfraTrafficType _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new HostInfraTrafficType(structValue);
    }

    /**
     * Builder class for {@link HostInfraTrafficType}.
     */
    public static final class Builder {
        private java.lang.String dynamicResPoolName;
        private java.lang.String trafficName;

        /**
         * Constructor with parameters for the required properties of
         * {@link HostInfraTrafficType}.
         */
        public Builder() {
        }

        /**
         * Dynamic resource pool traffic name
         *
         * @param dynamicResPoolName New value for the property.
         */
        public Builder setDynamicResPoolName(java.lang.String dynamicResPoolName) {
            this.dynamicResPoolName = dynamicResPoolName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_FAULT_TOLERANCE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_HBR}</li> <li>
         * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_ISCSI}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_MANAGEMENT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_NFS}</li> <li>
         * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VDP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VMOTION}</li> <li>
         * {@link com.vmware.nsx_policy.model.HostInfraTrafficType#TRAFFIC_NAME_VSAN}</li>
         * </ul> Traffic types
         *
         * @param trafficName New value for the property.
         */
        public Builder setTrafficName(java.lang.String trafficName) {
            this.trafficName = trafficName;
            return this;
        }

        public HostInfraTrafficType build() {
            HostInfraTrafficType result = new HostInfraTrafficType();
            result.setDynamicResPoolName(this.dynamicResPoolName);
            result.setTrafficName(this.trafficName);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dynamic_res_pool_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dynamic_res_pool_name",
                                                                                "dynamicResPoolName",
                                                                                "getDynamicResPoolName",
                                                                                "setDynamicResPoolName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("traffic_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("traffic_name",
                                                                                "trafficName",
                                                                                "getTrafficName",
                                                                                "setTrafficName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.host_infra_traffic_type",
                                                            fields,
                                                            com.vmware.nsx_policy.model.HostInfraTrafficType.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

