/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Contains IPv6 related discovery options.
 */
public final class IPv6DiscoveryOptions implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean dhcpSnoopingV6Enabled;

    private com.vmware.nsx_policy.model.NdSnoopingConfig ndSnoopingConfig;

    private java.lang.Boolean vmtoolsV6Enabled;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IPv6DiscoveryOptions() {
    }

    protected IPv6DiscoveryOptions(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Enable this method will snoop the DHCPv6 message transaction which a VM makes
     * with a DHCPv6 server. From the transaction, we learn the IPv6 addresses assigned
     * by the DHCPv6 server to this VM along with its lease time.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDhcpSnoopingV6Enabled() {
        return this.dhcpSnoopingV6Enabled;
    }

    /**
     * Enable this method will snoop the DHCPv6 message transaction which a VM makes
     * with a DHCPv6 server. From the transaction, we learn the IPv6 addresses assigned
     * by the DHCPv6 server to this VM along with its lease time.
     *
     * @param dhcpSnoopingV6Enabled New value for the property.
     */
    public void setDhcpSnoopingV6Enabled(java.lang.Boolean dhcpSnoopingV6Enabled) {
        this.dhcpSnoopingV6Enabled = dhcpSnoopingV6Enabled;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.NdSnoopingConfig getNdSnoopingConfig() {
        return this.ndSnoopingConfig;
    }

    /**
     *
     *
     * @param ndSnoopingConfig New value for the property.
     */
    public void setNdSnoopingConfig(com.vmware.nsx_policy.model.NdSnoopingConfig ndSnoopingConfig) {
        this.ndSnoopingConfig = ndSnoopingConfig;
    }

    /**
     * Enable this method will learn the IPv6 addresses which are configured on
     * interfaces of a VM with the help of the VMTools software.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVmtoolsV6Enabled() {
        return this.vmtoolsV6Enabled;
    }

    /**
     * Enable this method will learn the IPv6 addresses which are configured on
     * interfaces of a VM with the help of the VMTools software.
     *
     * @param vmtoolsV6Enabled New value for the property.
     */
    public void setVmtoolsV6Enabled(java.lang.Boolean vmtoolsV6Enabled) {
        this.vmtoolsV6Enabled = vmtoolsV6Enabled;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.IPv6DiscoveryOptions;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dhcp_snooping_v6_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpSnoopingV6Enabled, this._getType().getField("dhcp_snooping_v6_enabled")));
        structValue.setField("nd_snooping_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ndSnoopingConfig, this._getType().getField("nd_snooping_config")));
        structValue.setField("vmtools_v6_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmtoolsV6Enabled, this._getType().getField("vmtools_v6_enabled")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.IPv6DiscoveryOptions;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.IPv6DiscoveryOptions.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IPv6DiscoveryOptions _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IPv6DiscoveryOptions(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IPv6DiscoveryOptions _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IPv6DiscoveryOptions(structValue);
    }

    /**
     * Builder class for {@link IPv6DiscoveryOptions}.
     */
    public static final class Builder {
        private java.lang.Boolean dhcpSnoopingV6Enabled;
        private com.vmware.nsx_policy.model.NdSnoopingConfig ndSnoopingConfig;
        private java.lang.Boolean vmtoolsV6Enabled;

        /**
         * Constructor with parameters for the required properties of
         * {@link IPv6DiscoveryOptions}.
         */
        public Builder() {
        }

        /**
         * Enable this method will snoop the DHCPv6 message transaction which a VM makes
         * with a DHCPv6 server. From the transaction, we learn the IPv6 addresses assigned
         * by the DHCPv6 server to this VM along with its lease time.
         *
         * @param dhcpSnoopingV6Enabled New value for the property.
         */
        public Builder setDhcpSnoopingV6Enabled(java.lang.Boolean dhcpSnoopingV6Enabled) {
            this.dhcpSnoopingV6Enabled = dhcpSnoopingV6Enabled;
            return this;
        }

        /**
         *
         *
         * @param ndSnoopingConfig New value for the property.
         */
        public Builder setNdSnoopingConfig(com.vmware.nsx_policy.model.NdSnoopingConfig ndSnoopingConfig) {
            this.ndSnoopingConfig = ndSnoopingConfig;
            return this;
        }

        /**
         * Enable this method will learn the IPv6 addresses which are configured on
         * interfaces of a VM with the help of the VMTools software.
         *
         * @param vmtoolsV6Enabled New value for the property.
         */
        public Builder setVmtoolsV6Enabled(java.lang.Boolean vmtoolsV6Enabled) {
            this.vmtoolsV6Enabled = vmtoolsV6Enabled;
            return this;
        }

        public IPv6DiscoveryOptions build() {
            IPv6DiscoveryOptions result = new IPv6DiscoveryOptions();
            result.setDhcpSnoopingV6Enabled(this.dhcpSnoopingV6Enabled);
            result.setNdSnoopingConfig(this.ndSnoopingConfig);
            result.setVmtoolsV6Enabled(this.vmtoolsV6Enabled);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dhcp_snooping_v6_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_snooping_v6_enabled",
                                                                                "dhcpSnoopingV6Enabled",
                                                                                "getDhcpSnoopingV6Enabled",
                                                                                "setDhcpSnoopingV6Enabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nd_snooping_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ndSnoopingConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nd_snooping_config",
                                                                                "ndSnoopingConfig",
                                                                                "getNdSnoopingConfig",
                                                                                "setNdSnoopingConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vmtools_v6_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vmtools_v6_enabled",
                                                                                "vmtoolsV6Enabled",
                                                                                "getVmtoolsV6Enabled",
                                                                                "setVmtoolsV6Enabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.I_pv6_discovery_options",
                                                            fields,
                                                            com.vmware.nsx_policy.model.IPv6DiscoveryOptions.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

