/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Identity Firewall user session data on a client machine (typically a VM).
 * Multiple entries for the same user can be returned if the user logins to
 * multiple sessions on the same VM.
 */
public final class IdfwUserSessionData implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SESSION_SOURCE_GI = "GI";

    public static final java.lang.String SESSION_SOURCE_ELS = "ELS";

    public static final java.lang.String SESSION_SOURCE_LI = "LI";

    private java.lang.String domainName;

    private java.lang.String id;

    private java.lang.Long loginTime;

    private java.lang.Long logoutTime;

    private java.lang.String sessionSource;

    private java.lang.String userId;

    private java.lang.String userName;

    private java.lang.Long userSessionId;

    private java.lang.String vmExtId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IdfwUserSessionData() {
    }

    protected IdfwUserSessionData(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * AD Domain of user.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDomainName() {
        return this.domainName;
    }

    /**
     * AD Domain of user.
     *
     * @param domainName New value for the property.
     */
    public void setDomainName(java.lang.String domainName) {
        this.domainName = domainName;
    }

    /**
     * Identifier of user session data.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Identifier of user session data.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Login time. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLoginTime() {
        return this.loginTime;
    }

    /**
     * Login time. format: int64
     *
     * @param loginTime New value for the property.
     */
    public void setLoginTime(java.lang.Long loginTime) {
        this.loginTime = loginTime;
    }

    /**
     * Logout time if applicable. An active user session has no logout time. Non-active
     * user session is stored (up to last 5 most recent entries) per VM and per user.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLogoutTime() {
        return this.logoutTime;
    }

    /**
     * Logout time if applicable. An active user session has no logout time. Non-active
     * user session is stored (up to last 5 most recent entries) per VM and per user.
     * format: int64
     *
     * @param logoutTime New value for the property.
     */
    public void setLogoutTime(java.lang.Long logoutTime) {
        this.logoutTime = logoutTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_GI}</li> <li>
     * {@link com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_ELS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_LI}</li> </ul>
     * User session source can be one of: - GI (Guest Introspection) - ELS (AD Event
     * log server) - LI (Log Insight)
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSessionSource() {
        return this.sessionSource;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_GI}</li> <li>
     * {@link com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_ELS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_LI}</li> </ul>
     * User session source can be one of: - GI (Guest Introspection) - ELS (AD Event
     * log server) - LI (Log Insight)
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sessionSource New value for the property.
     */
    public void setSessionSource(java.lang.String sessionSource) {
        this.sessionSource = sessionSource;
    }

    /**
     * AD user ID (may not exist).
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserId() {
        return this.userId;
    }

    /**
     * AD user ID (may not exist).
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param userId New value for the property.
     */
    public void setUserId(java.lang.String userId) {
        this.userId = userId;
    }

    /**
     * AD user name.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserName() {
        return this.userName;
    }

    /**
     * AD user name.
     *
     * @param userName New value for the property.
     */
    public void setUserName(java.lang.String userName) {
        this.userName = userName;
    }

    /**
     * User session ID. This also indicates whether this is VDI / RDSH. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUserSessionId() {
        return this.userSessionId;
    }

    /**
     * User session ID. This also indicates whether this is VDI / RDSH. format: int64
     *
     * @param userSessionId New value for the property.
     */
    public void setUserSessionId(java.lang.Long userSessionId) {
        this.userSessionId = userSessionId;
    }

    /**
     * Virtual machine (external ID or BIOS UUID) where login/logout events occurred.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVmExtId() {
        return this.vmExtId;
    }

    /**
     * Virtual machine (external ID or BIOS UUID) where login/logout events occurred.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vmExtId New value for the property.
     */
    public void setVmExtId(java.lang.String vmExtId) {
        this.vmExtId = vmExtId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.idfwUserSessionData;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("domain_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.domainName, this._getType().getField("domain_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("login_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.loginTime, this._getType().getField("login_time")));
        structValue.setField("logout_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logoutTime, this._getType().getField("logout_time")));
        structValue.setField("session_source",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sessionSource, this._getType().getField("session_source")));
        structValue.setField("user_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userId, this._getType().getField("user_id")));
        structValue.setField("user_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userName, this._getType().getField("user_name")));
        structValue.setField("user_session_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userSessionId, this._getType().getField("user_session_id")));
        structValue.setField("vm_ext_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmExtId, this._getType().getField("vm_ext_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.idfwUserSessionData;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.idfwUserSessionData.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IdfwUserSessionData _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IdfwUserSessionData(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IdfwUserSessionData _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IdfwUserSessionData(structValue);
    }

    /**
     * Builder class for {@link IdfwUserSessionData}.
     */
    public static final class Builder {
        private java.lang.String domainName;
        private java.lang.String id;
        private java.lang.Long loginTime;
        private java.lang.Long logoutTime;
        private java.lang.String sessionSource;
        private java.lang.String userId;
        private java.lang.String userName;
        private java.lang.Long userSessionId;
        private java.lang.String vmExtId;

        /**
         * Constructor with parameters for the required properties of
         * {@link IdfwUserSessionData}.
         */
        public Builder() {
        }

        /**
         * AD Domain of user.
         *
         * @param domainName New value for the property.
         */
        public Builder setDomainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Identifier of user session data.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Login time. format: int64
         *
         * @param loginTime New value for the property.
         */
        public Builder setLoginTime(java.lang.Long loginTime) {
            this.loginTime = loginTime;
            return this;
        }

        /**
         * Logout time if applicable. An active user session has no logout time. Non-active
         * user session is stored (up to last 5 most recent entries) per VM and per user.
         * format: int64
         *
         * @param logoutTime New value for the property.
         */
        public Builder setLogoutTime(java.lang.Long logoutTime) {
            this.logoutTime = logoutTime;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_GI}</li> <li>
         * {@link com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_ELS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.IdfwUserSessionData#SESSION_SOURCE_LI}</li> </ul>
         * User session source can be one of: - GI (Guest Introspection) - ELS (AD Event
         * log server) - LI (Log Insight)
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sessionSource New value for the property.
         */
        public Builder setSessionSource(java.lang.String sessionSource) {
            this.sessionSource = sessionSource;
            return this;
        }

        /**
         * AD user ID (may not exist).
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param userId New value for the property.
         */
        public Builder setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
        }

        /**
         * AD user name.
         *
         * @param userName New value for the property.
         */
        public Builder setUserName(java.lang.String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * User session ID. This also indicates whether this is VDI / RDSH. format: int64
         *
         * @param userSessionId New value for the property.
         */
        public Builder setUserSessionId(java.lang.Long userSessionId) {
            this.userSessionId = userSessionId;
            return this;
        }

        /**
         * Virtual machine (external ID or BIOS UUID) where login/logout events occurred.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vmExtId New value for the property.
         */
        public Builder setVmExtId(java.lang.String vmExtId) {
            this.vmExtId = vmExtId;
            return this;
        }

        public IdfwUserSessionData build() {
            IdfwUserSessionData result = new IdfwUserSessionData();
            result.setDomainName(this.domainName);
            result.setId(this.id);
            result.setLoginTime(this.loginTime);
            result.setLogoutTime(this.logoutTime);
            result.setSessionSource(this.sessionSource);
            result.setUserId(this.userId);
            result.setUserName(this.userName);
            result.setUserSessionId(this.userSessionId);
            result.setVmExtId(this.vmExtId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("domain_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("domain_name",
                                                                                "domainName",
                                                                                "getDomainName",
                                                                                "setDomainName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("login_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("login_time",
                                                                                "loginTime",
                                                                                "getLoginTime",
                                                                                "setLoginTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("logout_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("logout_time",
                                                                                "logoutTime",
                                                                                "getLogoutTime",
                                                                                "setLogoutTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("session_source", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("session_source",
                                                                                "sessionSource",
                                                                                "getSessionSource",
                                                                                "setSessionSource");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_id",
                                                                                "userId",
                                                                                "getUserId",
                                                                                "setUserId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_name",
                                                                                "userName",
                                                                                "getUserName",
                                                                                "setUserName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_session_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_session_id",
                                                                                "userSessionId",
                                                                                "getUserSessionId",
                                                                                "setUserSessionId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vm_ext_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vm_ext_id",
                                                                                "vmExtId",
                                                                                "getVmExtId",
                                                                                "setVmExtId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.idfw_user_session_data",
                                                            fields,
                                                            com.vmware.nsx_policy.model.IdfwUserSessionData.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

