/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Duplicate address detection status for IP address on the interface.
 */
public final class InterfaceiPv6DADStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String STATUS_DUPLICATED = "DUPLICATED";

    public static final java.lang.String STATUS_TENTATIVE = "TENTATIVE";

    public static final java.lang.String STATUS_ASSIGNED = "ASSIGNED";

    public static final java.lang.String STATUS_NOT_APPLICABLE = "NOT_APPLICABLE";

    public static final java.lang.String STATUS_UNKNOWN = "UNKNOWN";

    private java.util.List<java.lang.String> edgePaths;

    private java.lang.String ipAddress;

    private java.lang.String status;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public InterfaceiPv6DADStatus() {
    }

    protected InterfaceiPv6DADStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Array of edge nodes on which DAD status is reported for given IP address.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getEdgePaths() {
        return this.edgePaths;
    }

    /**
     * Array of edge nodes on which DAD status is reported for given IP address.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param edgePaths New value for the property.
     */
    public void setEdgePaths(java.util.List<java.lang.String> edgePaths) {
        this.edgePaths = edgePaths;
    }

    /**
     * IP address on the port for which DAD status is reported. format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * IP address on the port for which DAD status is reported. format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_DUPLICATED}</li> <li>
     * {@link com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_TENTATIVE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_ASSIGNED}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_NOT_APPLICABLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_UNKNOWN}</li> </ul>
     * DAD status for IP address on the port.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_DUPLICATED}</li> <li>
     * {@link com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_TENTATIVE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_ASSIGNED}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_NOT_APPLICABLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_UNKNOWN}</li> </ul>
     * DAD status for IP address on the port.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.interfaceiPv6DADStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("edge_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.edgePaths, this._getType().getField("edge_paths")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.interfaceiPv6DADStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.interfaceiPv6DADStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static InterfaceiPv6DADStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new InterfaceiPv6DADStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static InterfaceiPv6DADStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new InterfaceiPv6DADStatus(structValue);
    }

    /**
     * Builder class for {@link InterfaceiPv6DADStatus}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> edgePaths;
        private java.lang.String ipAddress;
        private java.lang.String status;

        /**
         * Constructor with parameters for the required properties of
         * {@link InterfaceiPv6DADStatus}.
         */
        public Builder() {
        }

        /**
         * Array of edge nodes on which DAD status is reported for given IP address.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param edgePaths New value for the property.
         */
        public Builder setEdgePaths(java.util.List<java.lang.String> edgePaths) {
            this.edgePaths = edgePaths;
            return this;
        }

        /**
         * IP address on the port for which DAD status is reported. format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_DUPLICATED}</li> <li>
         * {@link com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_TENTATIVE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_ASSIGNED}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_NOT_APPLICABLE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.InterfaceiPv6DADStatus#STATUS_UNKNOWN}</li> </ul>
         * DAD status for IP address on the port.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        public InterfaceiPv6DADStatus build() {
            InterfaceiPv6DADStatus result = new InterfaceiPv6DADStatus();
            result.setEdgePaths(this.edgePaths);
            result.setIpAddress(this.ipAddress);
            result.setStatus(this.status);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("edge_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edge_paths",
                                                                                "edgePaths",
                                                                                "getEdgePaths",
                                                                                "setEdgePaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.interfacei_pv6_DAD_status",
                                                            fields,
                                                            com.vmware.nsx_policy.model.InterfaceiPv6DADStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

