/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * This action is used to control access to backend server resources using JSON Web
 * Token(JWT) authentication. The JWT authentication is done before any HTTP
 * manipulation if the HTTP request matches the given condition in LBRule. Any
 * verification failed, the HTTP process will be terminated, and HTTP response with
 * 401 status code and WWW-Authentication header will be returned to client.
 */
public final class LBJwtAuthAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBJwtAuthAction";

    private com.vmware.vapi.bindings.Structure key;

    private java.lang.Boolean passJwtToPool;

    private java.lang.String realm;

    private java.util.List<java.lang.String> tokens;

    private final java.lang.String type = "LBJwtAuthAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBJwtAuthAction() {
    }

    protected LBJwtAuthAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBJwtKey}. When methods return a value of this class
     * as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx_policy.model.LBJwtKey}.
     */
    public com.vmware.vapi.bindings.Structure getKey() {
        return this.key;
    }

    /**
     *
     *
     * @param key New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBJwtKey}. When methods return a value of this class
     * as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx_policy.model.LBJwtKey}.
     */
    public void setKey(com.vmware.vapi.bindings.Structure key) {
        this.key = key;
    }

    /**
     * Specify whether to pass the JWT to backend server or remove it. By default, it
     * is false which means will not pass the JWT to backend servers.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getPassJwtToPool() {
        return this.passJwtToPool;
    }

    /**
     * Specify whether to pass the JWT to backend server or remove it. By default, it
     * is false which means will not pass the JWT to backend servers.
     *
     * @param passJwtToPool New value for the property.
     */
    public void setPassJwtToPool(java.lang.Boolean passJwtToPool) {
        this.passJwtToPool = passJwtToPool;
    }

    /**
     * A description of the protected area. If no realm is specified, clients often
     * display a formatted hostname instead. The configured realm is returned when
     * client request is rejected with 401 http status. In the response, it will be
     * \"WWW-Authentication: Bearer realm=<realm>\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealm() {
        return this.realm;
    }

    /**
     * A description of the protected area. If no realm is specified, clients often
     * display a formatted hostname instead. The configured realm is returned when
     * client request is rejected with 401 http status. In the response, it will be
     * \"WWW-Authentication: Bearer realm=<realm>\".
     *
     * @param realm New value for the property.
     */
    public void setRealm(java.lang.String realm) {
        this.realm = realm;
    }

    /**
     * JWT is an open standard that defines a compact and self-contained way for
     * securely transmitting information between parties as a JSON object. Load
     * balancer will search for every specified tokens one by one for the jwt message
     * until found. This parameter is optional. In case not found or this field is not
     * configured, load balancer searches the Bearer header by default in the http
     * request \"Authorization: Bearer <token>\".
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getTokens() {
        return this.tokens;
    }

    /**
     * JWT is an open standard that defines a compact and self-contained way for
     * securely transmitting information between parties as a JSON object. Load
     * balancer will search for every specified tokens one by one for the jwt message
     * until found. This parameter is optional. In case not found or this field is not
     * configured, load balancer searches the Bearer header by default in the http
     * request \"Authorization: Bearer <token>\".
     *
     * @param tokens New value for the property.
     */
    public void setTokens(java.util.List<java.lang.String> tokens) {
        this.tokens = tokens;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBSELECTPOOLACTION}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREJECTACTION}</li> <li>
     * {@link com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREDIRECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBJWTAUTHACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBCONNECTIONDROPACTION}</li> </ul>
     * The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LBJwtAuthAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBJwtAuthAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("key",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.key, this._getType().getField("key")));
        structValue.setField("pass_jwt_to_pool",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.passJwtToPool, this._getType().getField("pass_jwt_to_pool")));
        structValue.setField("realm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realm, this._getType().getField("realm")));
        structValue.setField("tokens",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tokens, this._getType().getField("tokens")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBJwtAuthAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBJwtAuthAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBJwtAuthAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBJwtAuthAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBJwtAuthAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBJwtAuthAction(structValue);
    }

    /**
     * Builder class for {@link LBJwtAuthAction}.
     */
    public static final class Builder {
        private com.vmware.vapi.bindings.Structure key;
        private java.lang.Boolean passJwtToPool;
        private java.lang.String realm;
        private java.util.List<java.lang.String> tokens;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBJwtAuthAction}.
         */
        public Builder() {
        }

        /**
         *
         *
         * @param key New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.LBJwtKey}. When methods return a value of this class
         * as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx_policy.model.LBJwtKey}.
         */
        public Builder setKey(com.vmware.vapi.bindings.Structure key) {
            this.key = key;
            return this;
        }

        /**
         * Specify whether to pass the JWT to backend server or remove it. By default, it
         * is false which means will not pass the JWT to backend servers.
         *
         * @param passJwtToPool New value for the property.
         */
        public Builder setPassJwtToPool(java.lang.Boolean passJwtToPool) {
            this.passJwtToPool = passJwtToPool;
            return this;
        }

        /**
         * A description of the protected area. If no realm is specified, clients often
         * display a formatted hostname instead. The configured realm is returned when
         * client request is rejected with 401 http status. In the response, it will be
         * \"WWW-Authentication: Bearer realm=<realm>\".
         *
         * @param realm New value for the property.
         */
        public Builder setRealm(java.lang.String realm) {
            this.realm = realm;
            return this;
        }

        /**
         * JWT is an open standard that defines a compact and self-contained way for
         * securely transmitting information between parties as a JSON object. Load
         * balancer will search for every specified tokens one by one for the jwt message
         * until found. This parameter is optional. In case not found or this field is not
         * configured, load balancer searches the Bearer header by default in the http
         * request \"Authorization: Bearer <token>\".
         *
         * @param tokens New value for the property.
         */
        public Builder setTokens(java.util.List<java.lang.String> tokens) {
            this.tokens = tokens;
            return this;
        }

        public LBJwtAuthAction build() {
            LBJwtAuthAction result = new LBJwtAuthAction();
            result.setKey(this.key);
            result.setPassJwtToPool(this.passJwtToPool);
            result.setRealm(this.realm);
            result.setTokens(this.tokens);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("key", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBJwtKey; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("key",
                                                                                "key",
                                                                                "getKey",
                                                                                "setKey");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pass_jwt_to_pool", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pass_jwt_to_pool",
                                                                                "passJwtToPool",
                                                                                "getPassJwtToPool",
                                                                                "setPassJwtToPool");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realm",
                                                                                "realm",
                                                                                "getRealm",
                                                                                "setRealm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tokens", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tokens",
                                                                                "tokens",
                                                                                "getTokens",
                                                                                "setTokens");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_jwt_auth_action",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBJwtAuthAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBJwtAuthAction");
    }
}

