/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Result of prechecks run for onboarding remote site. The checks include NSX
 * version compatibility with PMaaS, Round Trip Time (RTT), etc. Note that some of
 * checks like RTT are soft limits. While the Pmaas_compatible field remains
 * PENDING the client should continue to intermittently re-read to determine when
 * the validation is complete.
 */
public final class PmaasCompatibilityCheckResult implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PMAAS_COMPATIBLE_COMPATIBLE = "COMPATIBLE";

    public static final java.lang.String PMAAS_COMPATIBLE_PENDING = "PENDING";

    public static final java.lang.String PMAAS_COMPATIBLE_INCOMPATIBLE = "INCOMPATIBLE";

    private java.lang.String localNsxVersion;

    private java.lang.String nsxVersion;

    private java.lang.Long rtt;

    private java.lang.Boolean rttExceeded;

    private java.lang.Boolean versionCompatible;

    private java.lang.String compatibilityErrorMessage;

    private java.lang.String pmaasCompatible;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PmaasCompatibilityCheckResult() {
    }

    protected PmaasCompatibilityCheckResult(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Local Site NSX version where active Global Mananger is running.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalNsxVersion() {
        return this.localNsxVersion;
    }

    /**
     * Local Site NSX version where active Global Mananger is running.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param localNsxVersion New value for the property.
     */
    public void setLocalNsxVersion(java.lang.String localNsxVersion) {
        this.localNsxVersion = localNsxVersion;
    }

    /**
     * Remote Site NSX version.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxVersion() {
        return this.nsxVersion;
    }

    /**
     * Remote Site NSX version.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nsxVersion New value for the property.
     */
    public void setNsxVersion(java.lang.String nsxVersion) {
        this.nsxVersion = nsxVersion;
    }

    /**
     * Round trip time to the remote Site or Global Manager from active Global Manager.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRtt() {
        return this.rtt;
    }

    /**
     * Round trip time to the remote Site or Global Manager from active Global Manager.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rtt New value for the property.
     */
    public void setRtt(java.lang.Long rtt) {
        this.rtt = rtt;
    }

    /**
     * Flag to indicate if RTT to remote Site exceeds the recommended limit.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRttExceeded() {
        return this.rttExceeded;
    }

    /**
     * Flag to indicate if RTT to remote Site exceeds the recommended limit.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rttExceeded New value for the property.
     */
    public void setRttExceeded(java.lang.Boolean rttExceeded) {
        this.rttExceeded = rttExceeded;
    }

    /**
     * Flag to indicate if remote Site NSX version is compatible with active Global
     * Manager.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVersionCompatible() {
        return this.versionCompatible;
    }

    /**
     * Flag to indicate if remote Site NSX version is compatible with active Global
     * Manager.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param versionCompatible New value for the property.
     */
    public void setVersionCompatible(java.lang.Boolean versionCompatible) {
        this.versionCompatible = versionCompatible;
    }

    /**
     * Result of prechecks run for onboarding remoet site to PMaaS. When the Site is
     * found to be INCOMPATIBLE this field will contain appropriate information or
     * error message.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCompatibilityErrorMessage() {
        return this.compatibilityErrorMessage;
    }

    /**
     * Result of prechecks run for onboarding remoet site to PMaaS. When the Site is
     * found to be INCOMPATIBLE this field will contain appropriate information or
     * error message.
     *
     * @param compatibilityErrorMessage New value for the property.
     */
    public void setCompatibilityErrorMessage(java.lang.String compatibilityErrorMessage) {
        this.compatibilityErrorMessage = compatibilityErrorMessage;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_COMPATIBLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_PENDING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_INCOMPATIBLE}</li>
     * </ul> Result of prechecks run for onboarding remote site. While the
     * pmaas_compatible field remains PENDING the client should continue to
     * intermittently re-read to determine when the validation is complete.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPmaasCompatible() {
        return this.pmaasCompatible;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_COMPATIBLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_PENDING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_INCOMPATIBLE}</li>
     * </ul> Result of prechecks run for onboarding remote site. While the
     * pmaas_compatible field remains PENDING the client should continue to
     * intermittently re-read to determine when the validation is complete.
     *
     * @param pmaasCompatible New value for the property.
     */
    public void setPmaasCompatible(java.lang.String pmaasCompatible) {
        this.pmaasCompatible = pmaasCompatible;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.pmaasCompatibilityCheckResult;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("local_nsx_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localNsxVersion, this._getType().getField("local_nsx_version")));
        structValue.setField("nsx_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxVersion, this._getType().getField("nsx_version")));
        structValue.setField("rtt",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rtt, this._getType().getField("rtt")));
        structValue.setField("rtt_exceeded",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rttExceeded, this._getType().getField("rtt_exceeded")));
        structValue.setField("version_compatible",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.versionCompatible, this._getType().getField("version_compatible")));
        structValue.setField("compatibility_error_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.compatibilityErrorMessage, this._getType().getField("compatibility_error_message")));
        structValue.setField("pmaas_compatible",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pmaasCompatible, this._getType().getField("pmaas_compatible")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.pmaasCompatibilityCheckResult;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.pmaasCompatibilityCheckResult.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PmaasCompatibilityCheckResult _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PmaasCompatibilityCheckResult(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PmaasCompatibilityCheckResult _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PmaasCompatibilityCheckResult(structValue);
    }

    /**
     * Builder class for {@link PmaasCompatibilityCheckResult}.
     */
    public static final class Builder {
        private java.lang.String localNsxVersion;
        private java.lang.String nsxVersion;
        private java.lang.Long rtt;
        private java.lang.Boolean rttExceeded;
        private java.lang.Boolean versionCompatible;
        private java.lang.String compatibilityErrorMessage;
        private java.lang.String pmaasCompatible;

        /**
         * Constructor with parameters for the required properties of
         * {@link PmaasCompatibilityCheckResult}.
         */
        public Builder() {
        }

        /**
         * Local Site NSX version where active Global Mananger is running.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param localNsxVersion New value for the property.
         */
        public Builder setLocalNsxVersion(java.lang.String localNsxVersion) {
            this.localNsxVersion = localNsxVersion;
            return this;
        }

        /**
         * Remote Site NSX version.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nsxVersion New value for the property.
         */
        public Builder setNsxVersion(java.lang.String nsxVersion) {
            this.nsxVersion = nsxVersion;
            return this;
        }

        /**
         * Round trip time to the remote Site or Global Manager from active Global Manager.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rtt New value for the property.
         */
        public Builder setRtt(java.lang.Long rtt) {
            this.rtt = rtt;
            return this;
        }

        /**
         * Flag to indicate if RTT to remote Site exceeds the recommended limit.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rttExceeded New value for the property.
         */
        public Builder setRttExceeded(java.lang.Boolean rttExceeded) {
            this.rttExceeded = rttExceeded;
            return this;
        }

        /**
         * Flag to indicate if remote Site NSX version is compatible with active Global
         * Manager.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param versionCompatible New value for the property.
         */
        public Builder setVersionCompatible(java.lang.Boolean versionCompatible) {
            this.versionCompatible = versionCompatible;
            return this;
        }

        /**
         * Result of prechecks run for onboarding remoet site to PMaaS. When the Site is
         * found to be INCOMPATIBLE this field will contain appropriate information or
         * error message.
         *
         * @param compatibilityErrorMessage New value for the property.
         */
        public Builder setCompatibilityErrorMessage(java.lang.String compatibilityErrorMessage) {
            this.compatibilityErrorMessage = compatibilityErrorMessage;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_COMPATIBLE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_PENDING}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult#PMAAS_COMPATIBLE_INCOMPATIBLE}</li>
         * </ul> Result of prechecks run for onboarding remote site. While the
         * pmaas_compatible field remains PENDING the client should continue to
         * intermittently re-read to determine when the validation is complete.
         *
         * @param pmaasCompatible New value for the property.
         */
        public Builder setPmaasCompatible(java.lang.String pmaasCompatible) {
            this.pmaasCompatible = pmaasCompatible;
            return this;
        }

        public PmaasCompatibilityCheckResult build() {
            PmaasCompatibilityCheckResult result = new PmaasCompatibilityCheckResult();
            result.setLocalNsxVersion(this.localNsxVersion);
            result.setNsxVersion(this.nsxVersion);
            result.setRtt(this.rtt);
            result.setRttExceeded(this.rttExceeded);
            result.setVersionCompatible(this.versionCompatible);
            result.setCompatibilityErrorMessage(this.compatibilityErrorMessage);
            result.setPmaasCompatible(this.pmaasCompatible);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("local_nsx_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_nsx_version",
                                                                                "localNsxVersion",
                                                                                "getLocalNsxVersion",
                                                                                "setLocalNsxVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsx_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsx_version",
                                                                                "nsxVersion",
                                                                                "getNsxVersion",
                                                                                "setNsxVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rtt", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rtt",
                                                                                "rtt",
                                                                                "getRtt",
                                                                                "setRtt");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rtt_exceeded", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rtt_exceeded",
                                                                                "rttExceeded",
                                                                                "getRttExceeded",
                                                                                "setRttExceeded");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("version_compatible", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("version_compatible",
                                                                                "versionCompatible",
                                                                                "getVersionCompatible",
                                                                                "setVersionCompatible");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("compatibility_error_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("compatibility_error_message",
                                                                                "compatibilityErrorMessage",
                                                                                "getCompatibilityErrorMessage",
                                                                                "setCompatibilityErrorMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pmaas_compatible", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pmaas_compatible",
                                                                                "pmaasCompatible",
                                                                                "getPmaasCompatible",
                                                                                "setPmaasCompatible");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.pmaas_compatibility_check_result",
                                                            fields,
                                                            com.vmware.nsx_policy.model.PmaasCompatibilityCheckResult.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

