/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Intrusion event with all the event and signature details, each event contains
 * the signature id, name, severity, first and recent occurence, users and VMs
 * affected and other signature metadata.
 */
public final class PolicyIdsEventsSummary implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long affectedIpCount;

    private java.lang.Long affectedVmCount;

    private java.lang.Long firstOccurence;

    private com.vmware.vapi.bindings.Structure idsFlowDetails;

    private java.lang.Boolean isOngoing;

    private java.lang.Boolean isRuleValid;

    private java.lang.Long latestOccurence;

    private java.lang.String projectPath;

    private java.lang.String resourceType;

    private java.lang.Long ruleId;

    private java.lang.Long signatureId;

    private com.vmware.vapi.bindings.Structure signatureMetadata;

    private java.lang.String siteId;

    private java.lang.Long totalCount;

    private com.vmware.vapi.bindings.Structure userDetails;

    private com.vmware.vapi.bindings.Structure vmDetails;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PolicyIdsEventsSummary() {
    }

    protected PolicyIdsEventsSummary(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Count of workload IPs on which a particular signature was detected. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAffectedIpCount() {
        return this.affectedIpCount;
    }

    /**
     * Count of workload IPs on which a particular signature was detected. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param affectedIpCount New value for the property.
     */
    public void setAffectedIpCount(java.lang.Long affectedIpCount) {
        this.affectedIpCount = affectedIpCount;
    }

    /**
     * Count of VMs on which a particular signature was detected. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAffectedVmCount() {
        return this.affectedVmCount;
    }

    /**
     * Count of VMs on which a particular signature was detected. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param affectedVmCount New value for the property.
     */
    public void setAffectedVmCount(java.lang.Long affectedVmCount) {
        this.affectedVmCount = affectedVmCount;
    }

    /**
     * First occurence of the intrusion, in epoch milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFirstOccurence() {
        return this.firstOccurence;
    }

    /**
     * First occurence of the intrusion, in epoch milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param firstOccurence New value for the property.
     */
    public void setFirstOccurence(java.lang.Long firstOccurence) {
        this.firstOccurence = firstOccurence;
    }

    /**
     * IDS event flow data specific to each IDS event. The data includes source ip,
     * source port, destination ip, destination port, and protocol.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.bindings.Structure getIdsFlowDetails() {
        return this.idsFlowDetails;
    }

    /**
     * IDS event flow data specific to each IDS event. The data includes source ip,
     * source port, destination ip, destination port, and protocol.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param idsFlowDetails New value for the property.
     */
    public void setIdsFlowDetails(com.vmware.vapi.bindings.Structure idsFlowDetails) {
        this.idsFlowDetails = idsFlowDetails;
    }

    /**
     * Flag indicating an ongoing intrusion.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsOngoing() {
        return this.isOngoing;
    }

    /**
     * Flag indicating an ongoing intrusion.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isOngoing New value for the property.
     */
    public void setIsOngoing(java.lang.Boolean isOngoing) {
        this.isOngoing = isOngoing;
    }

    /**
     * Indicates if the rule id is valid or not.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsRuleValid() {
        return this.isRuleValid;
    }

    /**
     * Indicates if the rule id is valid or not.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isRuleValid New value for the property.
     */
    public void setIsRuleValid(java.lang.Boolean isRuleValid) {
        this.isRuleValid = isRuleValid;
    }

    /**
     * Latest occurence of the intrusion, in epoch milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLatestOccurence() {
        return this.latestOccurence;
    }

    /**
     * Latest occurence of the intrusion, in epoch milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param latestOccurence New value for the property.
     */
    public void setLatestOccurence(java.lang.Long latestOccurence) {
        this.latestOccurence = latestOccurence;
    }

    /**
     * Project path
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProjectPath() {
        return this.projectPath;
    }

    /**
     * Project path
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param projectPath New value for the property.
     */
    public void setProjectPath(java.lang.String projectPath) {
        this.projectPath = projectPath;
    }

    /**
     * IDSEvent resource type.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * IDSEvent resource type.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * The IDS Rule id that detected this particular intrusion. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRuleId() {
        return this.ruleId;
    }

    /**
     * The IDS Rule id that detected this particular intrusion. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ruleId New value for the property.
     */
    public void setRuleId(java.lang.Long ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * Signature ID pertaining to the detected intrusion. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSignatureId() {
        return this.signatureId;
    }

    /**
     * Signature ID pertaining to the detected intrusion. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param signatureId New value for the property.
     */
    public void setSignatureId(java.lang.Long signatureId) {
        this.signatureId = signatureId;
    }

    /**
     * Metadata about the detected signature including name, id, severity, product
     * affected, protocol etc.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.bindings.Structure getSignatureMetadata() {
        return this.signatureMetadata;
    }

    /**
     * Metadata about the detected signature including name, id, severity, product
     * affected, protocol etc.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param signatureMetadata New value for the property.
     */
    public void setSignatureMetadata(com.vmware.vapi.bindings.Structure signatureMetadata) {
        this.signatureMetadata = signatureMetadata;
    }

    /**
     * Site Identifier
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSiteId() {
        return this.siteId;
    }

    /**
     * Site Identifier
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param siteId New value for the property.
     */
    public void setSiteId(java.lang.String siteId) {
        this.siteId = siteId;
    }

    /**
     * Number of times this particular signature was detected. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTotalCount() {
        return this.totalCount;
    }

    /**
     * Number of times this particular signature was detected. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param totalCount New value for the property.
     */
    public void setTotalCount(java.lang.Long totalCount) {
        this.totalCount = totalCount;
    }

    /**
     * List of users logged into VMs on which a particular signature was detected.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.bindings.Structure getUserDetails() {
        return this.userDetails;
    }

    /**
     * List of users logged into VMs on which a particular signature was detected.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param userDetails New value for the property.
     */
    public void setUserDetails(com.vmware.vapi.bindings.Structure userDetails) {
        this.userDetails = userDetails;
    }

    /**
     * List of VMs on which a particular signature was detected with the count.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.bindings.Structure getVmDetails() {
        return this.vmDetails;
    }

    /**
     * List of VMs on which a particular signature was detected with the count.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vmDetails New value for the property.
     */
    public void setVmDetails(com.vmware.vapi.bindings.Structure vmDetails) {
        this.vmDetails = vmDetails;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyIdsEventsSummary;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("affected_ip_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.affectedIpCount, this._getType().getField("affected_ip_count")));
        structValue.setField("affected_vm_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.affectedVmCount, this._getType().getField("affected_vm_count")));
        structValue.setField("first_occurence",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.firstOccurence, this._getType().getField("first_occurence")));
        structValue.setField("ids_flow_details",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.idsFlowDetails, this._getType().getField("ids_flow_details")));
        structValue.setField("is_ongoing",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isOngoing, this._getType().getField("is_ongoing")));
        structValue.setField("is_rule_valid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isRuleValid, this._getType().getField("is_rule_valid")));
        structValue.setField("latest_occurence",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.latestOccurence, this._getType().getField("latest_occurence")));
        structValue.setField("project_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.projectPath, this._getType().getField("project_path")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("rule_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ruleId, this._getType().getField("rule_id")));
        structValue.setField("signature_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.signatureId, this._getType().getField("signature_id")));
        structValue.setField("signature_metadata",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.signatureMetadata, this._getType().getField("signature_metadata")));
        structValue.setField("site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteId, this._getType().getField("site_id")));
        structValue.setField("total_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.totalCount, this._getType().getField("total_count")));
        structValue.setField("user_details",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userDetails, this._getType().getField("user_details")));
        structValue.setField("vm_details",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmDetails, this._getType().getField("vm_details")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyIdsEventsSummary;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.policyIdsEventsSummary.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PolicyIdsEventsSummary _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyIdsEventsSummary(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PolicyIdsEventsSummary _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyIdsEventsSummary(structValue);
    }

    /**
     * Builder class for {@link PolicyIdsEventsSummary}.
     */
    public static final class Builder {
        private java.lang.Long affectedIpCount;
        private java.lang.Long affectedVmCount;
        private java.lang.Long firstOccurence;
        private com.vmware.vapi.bindings.Structure idsFlowDetails;
        private java.lang.Boolean isOngoing;
        private java.lang.Boolean isRuleValid;
        private java.lang.Long latestOccurence;
        private java.lang.String projectPath;
        private java.lang.String resourceType;
        private java.lang.Long ruleId;
        private java.lang.Long signatureId;
        private com.vmware.vapi.bindings.Structure signatureMetadata;
        private java.lang.String siteId;
        private java.lang.Long totalCount;
        private com.vmware.vapi.bindings.Structure userDetails;
        private com.vmware.vapi.bindings.Structure vmDetails;

        /**
         * Constructor with parameters for the required properties of
         * {@link PolicyIdsEventsSummary}.
         */
        public Builder() {
        }

        /**
         * Count of workload IPs on which a particular signature was detected. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param affectedIpCount New value for the property.
         */
        public Builder setAffectedIpCount(java.lang.Long affectedIpCount) {
            this.affectedIpCount = affectedIpCount;
            return this;
        }

        /**
         * Count of VMs on which a particular signature was detected. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param affectedVmCount New value for the property.
         */
        public Builder setAffectedVmCount(java.lang.Long affectedVmCount) {
            this.affectedVmCount = affectedVmCount;
            return this;
        }

        /**
         * First occurence of the intrusion, in epoch milliseconds. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param firstOccurence New value for the property.
         */
        public Builder setFirstOccurence(java.lang.Long firstOccurence) {
            this.firstOccurence = firstOccurence;
            return this;
        }

        /**
         * IDS event flow data specific to each IDS event. The data includes source ip,
         * source port, destination ip, destination port, and protocol.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param idsFlowDetails New value for the property.
         */
        public Builder setIdsFlowDetails(com.vmware.vapi.bindings.Structure idsFlowDetails) {
            this.idsFlowDetails = idsFlowDetails;
            return this;
        }

        /**
         * Flag indicating an ongoing intrusion.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isOngoing New value for the property.
         */
        public Builder setIsOngoing(java.lang.Boolean isOngoing) {
            this.isOngoing = isOngoing;
            return this;
        }

        /**
         * Indicates if the rule id is valid or not.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isRuleValid New value for the property.
         */
        public Builder setIsRuleValid(java.lang.Boolean isRuleValid) {
            this.isRuleValid = isRuleValid;
            return this;
        }

        /**
         * Latest occurence of the intrusion, in epoch milliseconds. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param latestOccurence New value for the property.
         */
        public Builder setLatestOccurence(java.lang.Long latestOccurence) {
            this.latestOccurence = latestOccurence;
            return this;
        }

        /**
         * Project path
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param projectPath New value for the property.
         */
        public Builder setProjectPath(java.lang.String projectPath) {
            this.projectPath = projectPath;
            return this;
        }

        /**
         * IDSEvent resource type.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * The IDS Rule id that detected this particular intrusion. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ruleId New value for the property.
         */
        public Builder setRuleId(java.lang.Long ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        /**
         * Signature ID pertaining to the detected intrusion. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param signatureId New value for the property.
         */
        public Builder setSignatureId(java.lang.Long signatureId) {
            this.signatureId = signatureId;
            return this;
        }

        /**
         * Metadata about the detected signature including name, id, severity, product
         * affected, protocol etc.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param signatureMetadata New value for the property.
         */
        public Builder setSignatureMetadata(com.vmware.vapi.bindings.Structure signatureMetadata) {
            this.signatureMetadata = signatureMetadata;
            return this;
        }

        /**
         * Site Identifier
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param siteId New value for the property.
         */
        public Builder setSiteId(java.lang.String siteId) {
            this.siteId = siteId;
            return this;
        }

        /**
         * Number of times this particular signature was detected. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param totalCount New value for the property.
         */
        public Builder setTotalCount(java.lang.Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * List of users logged into VMs on which a particular signature was detected.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param userDetails New value for the property.
         */
        public Builder setUserDetails(com.vmware.vapi.bindings.Structure userDetails) {
            this.userDetails = userDetails;
            return this;
        }

        /**
         * List of VMs on which a particular signature was detected with the count.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vmDetails New value for the property.
         */
        public Builder setVmDetails(com.vmware.vapi.bindings.Structure vmDetails) {
            this.vmDetails = vmDetails;
            return this;
        }

        public PolicyIdsEventsSummary build() {
            PolicyIdsEventsSummary result = new PolicyIdsEventsSummary();
            result.setAffectedIpCount(this.affectedIpCount);
            result.setAffectedVmCount(this.affectedVmCount);
            result.setFirstOccurence(this.firstOccurence);
            result.setIdsFlowDetails(this.idsFlowDetails);
            result.setIsOngoing(this.isOngoing);
            result.setIsRuleValid(this.isRuleValid);
            result.setLatestOccurence(this.latestOccurence);
            result.setProjectPath(this.projectPath);
            result.setResourceType(this.resourceType);
            result.setRuleId(this.ruleId);
            result.setSignatureId(this.signatureId);
            result.setSignatureMetadata(this.signatureMetadata);
            result.setSiteId(this.siteId);
            result.setTotalCount(this.totalCount);
            result.setUserDetails(this.userDetails);
            result.setVmDetails(this.vmDetails);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("affected_ip_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("affected_ip_count",
                                                                                "affectedIpCount",
                                                                                "getAffectedIpCount",
                                                                                "setAffectedIpCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("affected_vm_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("affected_vm_count",
                                                                                "affectedVmCount",
                                                                                "getAffectedVmCount",
                                                                                "setAffectedVmCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("first_occurence", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("first_occurence",
                                                                                "firstOccurence",
                                                                                "getFirstOccurence",
                                                                                "setFirstOccurence");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ids_flow_details", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ids_flow_details",
                                                                                "idsFlowDetails",
                                                                                "getIdsFlowDetails",
                                                                                "setIdsFlowDetails");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_ongoing", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_ongoing",
                                                                                "isOngoing",
                                                                                "getIsOngoing",
                                                                                "setIsOngoing");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_rule_valid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_rule_valid",
                                                                                "isRuleValid",
                                                                                "getIsRuleValid",
                                                                                "setIsRuleValid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("latest_occurence", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("latest_occurence",
                                                                                "latestOccurence",
                                                                                "getLatestOccurence",
                                                                                "setLatestOccurence");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("project_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("project_path",
                                                                                "projectPath",
                                                                                "getProjectPath",
                                                                                "setProjectPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_id",
                                                                                "ruleId",
                                                                                "getRuleId",
                                                                                "setRuleId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("signature_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("signature_id",
                                                                                "signatureId",
                                                                                "getSignatureId",
                                                                                "setSignatureId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("signature_metadata", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("signature_metadata",
                                                                                "signatureMetadata",
                                                                                "getSignatureMetadata",
                                                                                "setSignatureMetadata");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_id",
                                                                                "siteId",
                                                                                "getSiteId",
                                                                                "setSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("total_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("total_count",
                                                                                "totalCount",
                                                                                "getTotalCount",
                                                                                "setTotalCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_details", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_details",
                                                                                "userDetails",
                                                                                "getUserDetails",
                                                                                "setUserDetails");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vm_details", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vm_details",
                                                                                "vmDetails",
                                                                                "getVmDetails",
                                                                                "setVmDetails");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.policy_ids_events_summary",
                                                            fields,
                                                            com.vmware.nsx_policy.model.PolicyIdsEventsSummary.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

