/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Detail information about port attachment
 */
public final class PortAttachment implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ALLOCATE_ADDRESSES_IP_POOL = "IP_POOL";

    public static final java.lang.String ALLOCATE_ADDRESSES_MAC_POOL = "MAC_POOL";

    public static final java.lang.String ALLOCATE_ADDRESSES_BOTH = "BOTH";

    public static final java.lang.String ALLOCATE_ADDRESSES_NONE = "NONE";

    public static final java.lang.String ALLOCATE_ADDRESSES_DHCP = "DHCP";

    public static final java.lang.String ALLOCATE_ADDRESSES_DHCPV6 = "DHCPV6";

    public static final java.lang.String ALLOCATE_ADDRESSES_SLAAC = "SLAAC";

    public static final java.lang.String CONTEXT_TYPE_PARENT = "PARENT";

    public static final java.lang.String HYPERBUS_MODE_ENABLE = "ENABLE";

    public static final java.lang.String HYPERBUS_MODE_DISABLE = "DISABLE";

    public static final java.lang.String TYPE_PARENT = "PARENT";

    public static final java.lang.String TYPE_CHILD = "CHILD";

    public static final java.lang.String TYPE_INDEPENDENT = "INDEPENDENT";

    public static final java.lang.String TYPE_STATIC = "STATIC";

    private java.lang.String allocateAddresses;

    private java.lang.String appId;

    private com.vmware.nsx_policy.model.AttachedInterfaceEntry bmsInterfaceConfig;

    private java.lang.String contextId;

    private java.lang.String contextType;

    private java.util.List<java.lang.String> evpnVlans;

    private java.lang.String hyperbusMode;

    private java.lang.String id;

    private java.lang.Long trafficTag;

    private java.lang.String type;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PortAttachment() {
    }

    protected PortAttachment(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_IP_POOL}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_MAC_POOL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_BOTH}</li> <li>
     * {@link com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_DHCP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_DHCPV6}</li> <li>
     * {@link com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_SLAAC}</li>
     * </ul> Indicate how IP will be allocated for the port
     *
     * @return The current value of the property.
     */
    public java.lang.String getAllocateAddresses() {
        return this.allocateAddresses;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_IP_POOL}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_MAC_POOL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_BOTH}</li> <li>
     * {@link com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_DHCP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_DHCPV6}</li> <li>
     * {@link com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_SLAAC}</li>
     * </ul> Indicate how IP will be allocated for the port
     *
     * @param allocateAddresses New value for the property.
     */
    public void setAllocateAddresses(java.lang.String allocateAddresses) {
        this.allocateAddresses = allocateAddresses;
    }

    /**
     * ID used to identify/look up a child attachment behind a parent attachment
     *
     * @return The current value of the property.
     */
    public java.lang.String getAppId() {
        return this.appId;
    }

    /**
     * ID used to identify/look up a child attachment behind a parent attachment
     *
     * @param appId New value for the property.
     */
    public void setAppId(java.lang.String appId) {
        this.appId = appId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.AttachedInterfaceEntry getBmsInterfaceConfig() {
        return this.bmsInterfaceConfig;
    }

    /**
     *
     *
     * @param bmsInterfaceConfig New value for the property.
     */
    public void setBmsInterfaceConfig(com.vmware.nsx_policy.model.AttachedInterfaceEntry bmsInterfaceConfig) {
        this.bmsInterfaceConfig = bmsInterfaceConfig;
    }

    /**
     * If type is CHILD and the parent port is on the same segment as the child port,
     * then this field should be VIF ID of the parent port. If type is CHILD and the
     * parent port is on a different segment, then this field should be policy path of
     * the parent port. If type is INDEPENDENT/STATIC, then this field should be
     * transport node ID.
     *
     * @return The current value of the property.
     */
    public java.lang.String getContextId() {
        return this.contextId;
    }

    /**
     * If type is CHILD and the parent port is on the same segment as the child port,
     * then this field should be VIF ID of the parent port. If type is CHILD and the
     * parent port is on a different segment, then this field should be policy path of
     * the parent port. If type is INDEPENDENT/STATIC, then this field should be
     * transport node ID.
     *
     * @param contextId New value for the property.
     */
    public void setContextId(java.lang.String contextId) {
        this.contextId = contextId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#CONTEXT_TYPE_PARENT}</li> </ul> Set
     * to PARENT when type field is CHILD. Read only field.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getContextType() {
        return this.contextType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#CONTEXT_TYPE_PARENT}</li> </ul> Set
     * to PARENT when type field is CHILD. Read only field.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param contextType New value for the property.
     */
    public void setContextType(java.lang.String contextType) {
        this.contextType = contextType;
    }

    /**
     * List of Evpn tenant VLAN IDs the Parent logical-port serves in Evpn Route-Server
     * mode. Only effective when attachment type is PARENT and the logical-port is
     * attached to vRouter VM.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getEvpnVlans() {
        return this.evpnVlans;
    }

    /**
     * List of Evpn tenant VLAN IDs the Parent logical-port serves in Evpn Route-Server
     * mode. Only effective when attachment type is PARENT and the logical-port is
     * attached to vRouter VM.
     *
     * @param evpnVlans New value for the property.
     */
    public void setEvpnVlans(java.util.List<java.lang.String> evpnVlans) {
        this.evpnVlans = evpnVlans;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#HYPERBUS_MODE_ENABLE}</li> <li>
     * {@link com.vmware.nsx_policy.model.PortAttachment#HYPERBUS_MODE_DISABLE}</li>
     * </ul> Flag to indicate if hyperbus configuration is required.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHyperbusMode() {
        return this.hyperbusMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#HYPERBUS_MODE_ENABLE}</li> <li>
     * {@link com.vmware.nsx_policy.model.PortAttachment#HYPERBUS_MODE_DISABLE}</li>
     * </ul> Flag to indicate if hyperbus configuration is required.
     *
     * @param hyperbusMode New value for the property.
     */
    public void setHyperbusMode(java.lang.String hyperbusMode) {
        this.hyperbusMode = hyperbusMode;
    }

    /**
     * VIF UUID on NSX Manager. If the attachement type is PARENT, this property is
     * required.
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * VIF UUID on NSX Manager. If the attachement type is PARENT, this property is
     * required.
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Not valid when type field is INDEPENDENT, mainly used to identify traffic from
     * different ports in container use case. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTrafficTag() {
        return this.trafficTag;
    }

    /**
     * Not valid when type field is INDEPENDENT, mainly used to identify traffic from
     * different ports in container use case. format: int64
     *
     * @param trafficTag New value for the property.
     */
    public void setTrafficTag(java.lang.Long trafficTag) {
        this.trafficTag = trafficTag;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_PARENT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_CHILD}</li> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_INDEPENDENT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_STATIC}</li> </ul> Type of port
     * attachment. STATIC is added to replace INDEPENDENT. INDEPENDENT type and PARENT
     * type are deprecated.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_PARENT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_CHILD}</li> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_INDEPENDENT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PortAttachment#TYPE_STATIC}</li> </ul> Type of port
     * attachment. STATIC is added to replace INDEPENDENT. INDEPENDENT type and PARENT
     * type are deprecated.
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.portAttachment;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allocate_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allocateAddresses, this._getType().getField("allocate_addresses")));
        structValue.setField("app_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.appId, this._getType().getField("app_id")));
        structValue.setField("bms_interface_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bmsInterfaceConfig, this._getType().getField("bms_interface_config")));
        structValue.setField("context_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.contextId, this._getType().getField("context_id")));
        structValue.setField("context_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.contextType, this._getType().getField("context_type")));
        structValue.setField("evpn_vlans",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.evpnVlans, this._getType().getField("evpn_vlans")));
        structValue.setField("hyperbus_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hyperbusMode, this._getType().getField("hyperbus_mode")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("traffic_tag",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.trafficTag, this._getType().getField("traffic_tag")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.portAttachment;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.portAttachment.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PortAttachment _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PortAttachment(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PortAttachment _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PortAttachment(structValue);
    }

    /**
     * Builder class for {@link PortAttachment}.
     */
    public static final class Builder {
        private java.lang.String allocateAddresses;
        private java.lang.String appId;
        private com.vmware.nsx_policy.model.AttachedInterfaceEntry bmsInterfaceConfig;
        private java.lang.String contextId;
        private java.lang.String contextType;
        private java.util.List<java.lang.String> evpnVlans;
        private java.lang.String hyperbusMode;
        private java.lang.String id;
        private java.lang.Long trafficTag;
        private java.lang.String type;

        /**
         * Constructor with parameters for the required properties of
         * {@link PortAttachment}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_IP_POOL}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_MAC_POOL}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_BOTH}</li> <li>
         * {@link com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_DHCP}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_DHCPV6}</li> <li>
         * {@link com.vmware.nsx_policy.model.PortAttachment#ALLOCATE_ADDRESSES_SLAAC}</li>
         * </ul> Indicate how IP will be allocated for the port
         *
         * @param allocateAddresses New value for the property.
         */
        public Builder setAllocateAddresses(java.lang.String allocateAddresses) {
            this.allocateAddresses = allocateAddresses;
            return this;
        }

        /**
         * ID used to identify/look up a child attachment behind a parent attachment
         *
         * @param appId New value for the property.
         */
        public Builder setAppId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         *
         *
         * @param bmsInterfaceConfig New value for the property.
         */
        public Builder setBmsInterfaceConfig(com.vmware.nsx_policy.model.AttachedInterfaceEntry bmsInterfaceConfig) {
            this.bmsInterfaceConfig = bmsInterfaceConfig;
            return this;
        }

        /**
         * If type is CHILD and the parent port is on the same segment as the child port,
         * then this field should be VIF ID of the parent port. If type is CHILD and the
         * parent port is on a different segment, then this field should be policy path of
         * the parent port. If type is INDEPENDENT/STATIC, then this field should be
         * transport node ID.
         *
         * @param contextId New value for the property.
         */
        public Builder setContextId(java.lang.String contextId) {
            this.contextId = contextId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#CONTEXT_TYPE_PARENT}</li> </ul> Set
         * to PARENT when type field is CHILD. Read only field.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param contextType New value for the property.
         */
        public Builder setContextType(java.lang.String contextType) {
            this.contextType = contextType;
            return this;
        }

        /**
         * List of Evpn tenant VLAN IDs the Parent logical-port serves in Evpn Route-Server
         * mode. Only effective when attachment type is PARENT and the logical-port is
         * attached to vRouter VM.
         *
         * @param evpnVlans New value for the property.
         */
        public Builder setEvpnVlans(java.util.List<java.lang.String> evpnVlans) {
            this.evpnVlans = evpnVlans;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#HYPERBUS_MODE_ENABLE}</li> <li>
         * {@link com.vmware.nsx_policy.model.PortAttachment#HYPERBUS_MODE_DISABLE}</li>
         * </ul> Flag to indicate if hyperbus configuration is required.
         *
         * @param hyperbusMode New value for the property.
         */
        public Builder setHyperbusMode(java.lang.String hyperbusMode) {
            this.hyperbusMode = hyperbusMode;
            return this;
        }

        /**
         * VIF UUID on NSX Manager. If the attachement type is PARENT, this property is
         * required.
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Not valid when type field is INDEPENDENT, mainly used to identify traffic from
         * different ports in container use case. format: int64
         *
         * @param trafficTag New value for the property.
         */
        public Builder setTrafficTag(java.lang.Long trafficTag) {
            this.trafficTag = trafficTag;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#TYPE_PARENT}</li> <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#TYPE_CHILD}</li> <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#TYPE_INDEPENDENT}</li> <li> {@link
         * com.vmware.nsx_policy.model.PortAttachment#TYPE_STATIC}</li> </ul> Type of port
         * attachment. STATIC is added to replace INDEPENDENT. INDEPENDENT type and PARENT
         * type are deprecated.
         *
         * @param type New value for the property.
         */
        public Builder setType(java.lang.String type) {
            this.type = type;
            return this;
        }

        public PortAttachment build() {
            PortAttachment result = new PortAttachment();
            result.setAllocateAddresses(this.allocateAddresses);
            result.setAppId(this.appId);
            result.setBmsInterfaceConfig(this.bmsInterfaceConfig);
            result.setContextId(this.contextId);
            result.setContextType(this.contextType);
            result.setEvpnVlans(this.evpnVlans);
            result.setHyperbusMode(this.hyperbusMode);
            result.setId(this.id);
            result.setTrafficTag(this.trafficTag);
            result.setType(this.type);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allocate_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allocate_addresses",
                                                                                "allocateAddresses",
                                                                                "getAllocateAddresses",
                                                                                "setAllocateAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("app_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("app_id",
                                                                                "appId",
                                                                                "getAppId",
                                                                                "setAppId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bms_interface_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.attachedInterfaceEntry; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bms_interface_config",
                                                                                "bmsInterfaceConfig",
                                                                                "getBmsInterfaceConfig",
                                                                                "setBmsInterfaceConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("context_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("context_id",
                                                                                "contextId",
                                                                                "getContextId",
                                                                                "setContextId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("context_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("context_type",
                                                                                "contextType",
                                                                                "getContextType",
                                                                                "setContextType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("evpn_vlans", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("evpn_vlans",
                                                                                "evpnVlans",
                                                                                "getEvpnVlans",
                                                                                "setEvpnVlans");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hyperbus_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hyperbus_mode",
                                                                                "hyperbusMode",
                                                                                "getHyperbusMode",
                                                                                "setHyperbusMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("traffic_tag", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("traffic_tag",
                                                                                "trafficTag",
                                                                                "getTrafficTag",
                                                                                "setTrafficTag");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.port_attachment",
                                                            fields,
                                                            com.vmware.nsx_policy.model.PortAttachment.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

