/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * User/Group's role binding
 */
public final class RoleBinding implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String IDENTITY_SOURCE_TYPE_VIDM = "VIDM";

    public static final java.lang.String IDENTITY_SOURCE_TYPE_LDAP = "LDAP";

    public static final java.lang.String IDENTITY_SOURCE_TYPE_OIDC = "OIDC";

    public static final java.lang.String IDENTITY_SOURCE_TYPE_CSP = "CSP";

    public static final java.lang.String STALE_TRUE = "TRUE";

    public static final java.lang.String STALE_FALSE = "FALSE";

    public static final java.lang.String STALE_UNKNOWN = "UNKNOWN";

    public static final java.lang.String TYPE_REMOTE_USER = "remote_user";

    public static final java.lang.String TYPE_REMOTE_GROUP = "remote_group";

    public static final java.lang.String TYPE_LOCAL_USER = "local_user";

    public static final java.lang.String TYPE_PRINCIPAL_IDENTITY = "principal_identity";

    private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_policy.model.Tag> tags;

    private java.lang.String identitySourceId;

    private java.lang.String identitySourceType;

    private java.lang.String name;

    private java.lang.Boolean readRolesForPaths;

    private java.util.List<com.vmware.nsx_policy.model.Role> roles;

    private java.util.List<com.vmware.nsx_policy.model.RolesForPath> rolesForPaths;

    private java.lang.String stale;

    private java.lang.String type;

    private java.lang.String userId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public RoleBinding() {
    }

    protected RoleBinding(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * The ID of the external identity source that holds the referenced external
     * entity. Currently, only external LDAP and OIDC servers are allowed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIdentitySourceId() {
        return this.identitySourceId;
    }

    /**
     * The ID of the external identity source that holds the referenced external
     * entity. Currently, only external LDAP and OIDC servers are allowed.
     *
     * @param identitySourceId New value for the property.
     */
    public void setIdentitySourceId(java.lang.String identitySourceId) {
        this.identitySourceId = identitySourceId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_VIDM}</li> <li>
     * {@link com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_LDAP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_OIDC}</li> <li>
     * {@link com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_CSP}</li>
     * </ul> Identity source type
     *
     * @return The current value of the property.
     */
    public java.lang.String getIdentitySourceType() {
        return this.identitySourceType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_VIDM}</li> <li>
     * {@link com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_LDAP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_OIDC}</li> <li>
     * {@link com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_CSP}</li>
     * </ul> Identity source type
     *
     * @param identitySourceType New value for the property.
     */
    public void setIdentitySourceType(java.lang.String identitySourceType) {
        this.identitySourceType = identitySourceType;
    }

    /**
     * User/Group's name
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * User/Group's name
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Set this property to true to cause the user's role definition to be read from
     * the roles_for_paths property. Set it to false to cause the user's role
     * definition to be read from the roles property.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getReadRolesForPaths() {
        return this.readRolesForPaths;
    }

    /**
     * Set this property to true to cause the user's role definition to be read from
     * the roles_for_paths property. Set it to false to cause the user's role
     * definition to be read from the roles property.
     *
     * @param readRolesForPaths New value for the property.
     */
    public void setReadRolesForPaths(java.lang.Boolean readRolesForPaths) {
        this.readRolesForPaths = readRolesForPaths;
    }

    /**
     * Roles
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx_policy.model.Role> getRoles() {
        return this.roles;
    }

    /**
     * Roles
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param roles New value for the property.
     */
    @Deprecated
    public void setRoles(java.util.List<com.vmware.nsx_policy.model.Role> roles) {
        this.roles = roles;
    }

    /**
     * The roles that are associated with the user, limiting them to a path. In case
     * the path is '/', the roles apply everywhere i.e. it is same as the deprecated
     * property roles.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.RolesForPath> getRolesForPaths() {
        return this.rolesForPaths;
    }

    /**
     * The roles that are associated with the user, limiting them to a path. In case
     * the path is '/', the roles apply everywhere i.e. it is same as the deprecated
     * property roles.
     *
     * @param rolesForPaths New value for the property.
     */
    public void setRolesForPaths(java.util.List<com.vmware.nsx_policy.model.RolesForPath> rolesForPaths) {
        this.rolesForPaths = rolesForPaths;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#STALE_TRUE}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#STALE_FALSE}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#STALE_UNKNOWN}</li> </ul> Property
     * 'stale' can be considered to have these values - absent - This type of
     * rolebinding does not support stale property TRUE - Rolebinding is stale in vIDM
     * meaning the user is no longer present in vIDM FALSE - Rolebinding is available
     * in vIDM UNKNOWN - Rolebinding's state of staleness in unknown Once rolebindings
     * become stale, they can be deleted using the API POST
     * /aaa/role-bindings?action=delete_stale_bindings
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStale() {
        return this.stale;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#STALE_TRUE}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#STALE_FALSE}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#STALE_UNKNOWN}</li> </ul> Property
     * 'stale' can be considered to have these values - absent - This type of
     * rolebinding does not support stale property TRUE - Rolebinding is stale in vIDM
     * meaning the user is no longer present in vIDM FALSE - Rolebinding is available
     * in vIDM UNKNOWN - Rolebinding's state of staleness in unknown Once rolebindings
     * become stale, they can be deleted using the API POST
     * /aaa/role-bindings?action=delete_stale_bindings
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param stale New value for the property.
     */
    public void setStale(java.lang.String stale) {
        this.stale = stale;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_REMOTE_USER}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_REMOTE_GROUP}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_LOCAL_USER}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_PRINCIPAL_IDENTITY}</li> </ul> Type
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_REMOTE_USER}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_REMOTE_GROUP}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_LOCAL_USER}</li> <li> {@link
     * com.vmware.nsx_policy.model.RoleBinding#TYPE_PRINCIPAL_IDENTITY}</li> </ul> Type
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

    /**
     * Local user's numeric id on the system.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserId() {
        return this.userId;
    }

    /**
     * Local user's numeric id on the system.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param userId New value for the property.
     */
    public void setUserId(java.lang.String userId) {
        this.userId = userId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.roleBinding;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("identity_source_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.identitySourceId, this._getType().getField("identity_source_id")));
        structValue.setField("identity_source_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.identitySourceType, this._getType().getField("identity_source_type")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("read_roles_for_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.readRolesForPaths, this._getType().getField("read_roles_for_paths")));
        structValue.setField("roles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.roles, this._getType().getField("roles")));
        structValue.setField("roles_for_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rolesForPaths, this._getType().getField("roles_for_paths")));
        structValue.setField("stale",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.stale, this._getType().getField("stale")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
        structValue.setField("user_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userId, this._getType().getField("user_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.roleBinding;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.roleBinding.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static RoleBinding _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new RoleBinding(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static RoleBinding _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new RoleBinding(structValue);
    }

    /**
     * Builder class for {@link RoleBinding}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_policy.model.Tag> tags;
        private java.lang.String identitySourceId;
        private java.lang.String identitySourceType;
        private java.lang.String name;
        private java.lang.Boolean readRolesForPaths;
        private java.util.List<com.vmware.nsx_policy.model.Role> roles;
        private java.util.List<com.vmware.nsx_policy.model.RolesForPath> rolesForPaths;
        private java.lang.String stale;
        private java.lang.String type;
        private java.lang.String userId;

        /**
         * Constructor with parameters for the required properties of
         * {@link RoleBinding}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * The ID of the external identity source that holds the referenced external
         * entity. Currently, only external LDAP and OIDC servers are allowed.
         *
         * @param identitySourceId New value for the property.
         */
        public Builder setIdentitySourceId(java.lang.String identitySourceId) {
            this.identitySourceId = identitySourceId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_VIDM}</li> <li>
         * {@link com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_LDAP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_OIDC}</li> <li>
         * {@link com.vmware.nsx_policy.model.RoleBinding#IDENTITY_SOURCE_TYPE_CSP}</li>
         * </ul> Identity source type
         *
         * @param identitySourceType New value for the property.
         */
        public Builder setIdentitySourceType(java.lang.String identitySourceType) {
            this.identitySourceType = identitySourceType;
            return this;
        }

        /**
         * User/Group's name
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Set this property to true to cause the user's role definition to be read from
         * the roles_for_paths property. Set it to false to cause the user's role
         * definition to be read from the roles property.
         *
         * @param readRolesForPaths New value for the property.
         */
        public Builder setReadRolesForPaths(java.lang.Boolean readRolesForPaths) {
            this.readRolesForPaths = readRolesForPaths;
            return this;
        }

        /**
         * Roles
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param roles New value for the property.
         */
        public Builder setRoles(java.util.List<com.vmware.nsx_policy.model.Role> roles) {
            this.roles = roles;
            return this;
        }

        /**
         * The roles that are associated with the user, limiting them to a path. In case
         * the path is '/', the roles apply everywhere i.e. it is same as the deprecated
         * property roles.
         *
         * @param rolesForPaths New value for the property.
         */
        public Builder setRolesForPaths(java.util.List<com.vmware.nsx_policy.model.RolesForPath> rolesForPaths) {
            this.rolesForPaths = rolesForPaths;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#STALE_TRUE}</li> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#STALE_FALSE}</li> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#STALE_UNKNOWN}</li> </ul> Property
         * 'stale' can be considered to have these values - absent - This type of
         * rolebinding does not support stale property TRUE - Rolebinding is stale in vIDM
         * meaning the user is no longer present in vIDM FALSE - Rolebinding is available
         * in vIDM UNKNOWN - Rolebinding's state of staleness in unknown Once rolebindings
         * become stale, they can be deleted using the API POST
         * /aaa/role-bindings?action=delete_stale_bindings
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param stale New value for the property.
         */
        public Builder setStale(java.lang.String stale) {
            this.stale = stale;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#TYPE_REMOTE_USER}</li> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#TYPE_REMOTE_GROUP}</li> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#TYPE_LOCAL_USER}</li> <li> {@link
         * com.vmware.nsx_policy.model.RoleBinding#TYPE_PRINCIPAL_IDENTITY}</li> </ul> Type
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param type New value for the property.
         */
        public Builder setType(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Local user's numeric id on the system.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param userId New value for the property.
         */
        public Builder setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
        }

        public RoleBinding build() {
            RoleBinding result = new RoleBinding();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setIdentitySourceId(this.identitySourceId);
            result.setIdentitySourceType(this.identitySourceType);
            result.setName(this.name);
            result.setReadRolesForPaths(this.readRolesForPaths);
            result.setRoles(this.roles);
            result.setRolesForPaths(this.rolesForPaths);
            result.setStale(this.stale);
            result.setType(this.type);
            result.setUserId(this.userId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("identity_source_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("identity_source_id",
                                                                                "identitySourceId",
                                                                                "getIdentitySourceId",
                                                                                "setIdentitySourceId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("identity_source_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("identity_source_type",
                                                                                "identitySourceType",
                                                                                "getIdentitySourceType",
                                                                                "setIdentitySourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("read_roles_for_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("read_roles_for_paths",
                                                                                "readRolesForPaths",
                                                                                "getReadRolesForPaths",
                                                                                "setReadRolesForPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("roles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.role; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("roles",
                                                                                "roles",
                                                                                "getRoles",
                                                                                "setRoles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("roles_for_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.rolesForPath; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("roles_for_paths",
                                                                                "rolesForPaths",
                                                                                "getRolesForPaths",
                                                                                "setRolesForPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("stale", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("stale",
                                                                                "stale",
                                                                                "getStale",
                                                                                "setStale");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_id",
                                                                                "userId",
                                                                                "getUserId",
                                                                                "setUserId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.role_binding",
                                                            fields,
                                                            com.vmware.nsx_policy.model.RoleBinding.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

