/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Registering a Service is the first step in the ServiceInsertion mechanism. A
 * ServiceDefinition is used to create a service.
 */
public final class ServiceDefinition implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ATTACHMENT_POINT_TIER0_LR = "TIER0_LR";

    public static final java.lang.String ATTACHMENT_POINT_TIER1_LR = "TIER1_LR";

    public static final java.lang.String ATTACHMENT_POINT_SERVICE_PLANE = "SERVICE_PLANE";

    public static final java.lang.String FUNCTIONALITIES_NG_FW = "NG_FW";

    public static final java.lang.String FUNCTIONALITIES_IDS_IPS = "IDS_IPS";

    public static final java.lang.String FUNCTIONALITIES_NET_MON = "NET_MON";

    public static final java.lang.String FUNCTIONALITIES_HCX = "HCX";

    public static final java.lang.String FUNCTIONALITIES_BYOD = "BYOD";

    public static final java.lang.String FUNCTIONALITIES_EPP = "EPP";

    public static final java.lang.String FUNCTIONALITIES_TLB = "TLB";

    public static final java.lang.String FUNCTIONALITIES_MPS = "MPS";

    public static final java.lang.String IMPLEMENTATIONS_NORTH_SOUTH = "NORTH_SOUTH";

    public static final java.lang.String IMPLEMENTATIONS_EAST_WEST = "EAST_WEST";

    public static final java.lang.String ON_FAILURE_POLICY_ALLOW = "ALLOW";

    public static final java.lang.String ON_FAILURE_POLICY_BLOCK = "BLOCK";

    public static final java.lang.String TRANSPORTS_L2_BRIDGE = "L2_BRIDGE";

    public static final java.lang.String TRANSPORTS_L3_ROUTED = "L3_ROUTED";

    public static final java.lang.String TRANSPORTS_NSH = "NSH";

    private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_policy.model.Tag> tags;

    private java.util.List<java.lang.String> attachmentPoint;

    private java.util.List<java.lang.String> functionalities;

    private java.util.List<java.lang.String> implementations;

    private java.lang.String onFailurePolicy;

    private com.vmware.nsx_policy.model.ServiceCapability serviceCapability;

    private com.vmware.nsx_policy.model.ServiceDeploymentSpec serviceDeploymentSpec;

    private java.lang.String serviceManagerId;

    private java.util.List<java.lang.String> transports;

    private java.lang.String vendorId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ServiceDefinition() {
    }

    protected ServiceDefinition(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_TIER0_LR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_TIER1_LR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_SERVICE_PLANE}</li>
     * </ul> The point at which the service is deployed/attached for redirecting the
     * traffic to the the partner appliance. Attachment Point is required if Service
     * caters to any functionality other than EPP and MPS.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAttachmentPoint() {
        return this.attachmentPoint;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_TIER0_LR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_TIER1_LR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_SERVICE_PLANE}</li>
     * </ul> The point at which the service is deployed/attached for redirecting the
     * traffic to the the partner appliance. Attachment Point is required if Service
     * caters to any functionality other than EPP and MPS.
     *
     * @param attachmentPoint New value for the property.
     */
    public void setAttachmentPoint(java.util.List<java.lang.String> attachmentPoint) {
        this.attachmentPoint = attachmentPoint;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_NG_FW}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_IDS_IPS}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_NET_MON}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_HCX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_BYOD}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_EPP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_TLB}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_MPS}</li>
     * </ul> The capabilities provided by the services. Needs to be one or more of the
     * following | NG_FW - Next Generation Firewall | IDS_IPS - Intrusion Detection
     * System / Intrusion Prevention System | NET_MON - Network Monitoring | HCX -
     * Hybrid Cloud Exchange | BYOD - Bring Your Own Device | TLB - Transparent Load
     * Balancer | EPP - Endpoint Protection.(Third party AntiVirus partners using NXGI
     * should use this functionality for the service) | MPS - Malware Prevention
     * Solution
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getFunctionalities() {
        return this.functionalities;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_NG_FW}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_IDS_IPS}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_NET_MON}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_HCX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_BYOD}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_EPP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_TLB}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_MPS}</li>
     * </ul> The capabilities provided by the services. Needs to be one or more of the
     * following | NG_FW - Next Generation Firewall | IDS_IPS - Intrusion Detection
     * System / Intrusion Prevention System | NET_MON - Network Monitoring | HCX -
     * Hybrid Cloud Exchange | BYOD - Bring Your Own Device | TLB - Transparent Load
     * Balancer | EPP - Endpoint Protection.(Third party AntiVirus partners using NXGI
     * should use this functionality for the service) | MPS - Malware Prevention
     * Solution
     *
     * @param functionalities New value for the property.
     */
    public void setFunctionalities(java.util.List<java.lang.String> functionalities) {
        this.functionalities = functionalities;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#IMPLEMENTATIONS_NORTH_SOUTH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#IMPLEMENTATIONS_EAST_WEST}</li>
     * </ul> This indicates the insertion point of the service i.e whether the service
     * will be used to protect North-South or East-West traffic in the datacenter.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getImplementations() {
        return this.implementations;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#IMPLEMENTATIONS_NORTH_SOUTH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#IMPLEMENTATIONS_EAST_WEST}</li>
     * </ul> This indicates the insertion point of the service i.e whether the service
     * will be used to protect North-South or East-West traffic in the datacenter.
     *
     * @param implementations New value for the property.
     */
    public void setImplementations(java.util.List<java.lang.String> implementations) {
        this.implementations = implementations;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ON_FAILURE_POLICY_ALLOW}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ON_FAILURE_POLICY_BLOCK}</li>
     * </ul> Failure policy for the service tells datapath, the action to take i.e to
     * Allow or Block traffic during failure scenarios. For north-south
     * ServiceInsertion, failure policy in the service instance takes precedence. For
     * east-west ServiceInsertion, failure policy in the service chain takes
     * precedence. BLOCK is not supported for Endpoint protection (EPP) and MPS
     * functionality.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOnFailurePolicy() {
        return this.onFailurePolicy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ON_FAILURE_POLICY_ALLOW}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#ON_FAILURE_POLICY_BLOCK}</li>
     * </ul> Failure policy for the service tells datapath, the action to take i.e to
     * Allow or Block traffic during failure scenarios. For north-south
     * ServiceInsertion, failure policy in the service instance takes precedence. For
     * east-west ServiceInsertion, failure policy in the service chain takes
     * precedence. BLOCK is not supported for Endpoint protection (EPP) and MPS
     * functionality.
     *
     * @param onFailurePolicy New value for the property.
     */
    public void setOnFailurePolicy(java.lang.String onFailurePolicy) {
        this.onFailurePolicy = onFailurePolicy;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ServiceCapability getServiceCapability() {
        return this.serviceCapability;
    }

    /**
     *
     *
     * @param serviceCapability New value for the property.
     */
    public void setServiceCapability(com.vmware.nsx_policy.model.ServiceCapability serviceCapability) {
        this.serviceCapability = serviceCapability;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ServiceDeploymentSpec getServiceDeploymentSpec() {
        return this.serviceDeploymentSpec;
    }

    /**
     *
     *
     * @param serviceDeploymentSpec New value for the property.
     */
    public void setServiceDeploymentSpec(com.vmware.nsx_policy.model.ServiceDeploymentSpec serviceDeploymentSpec) {
        this.serviceDeploymentSpec = serviceDeploymentSpec;
    }

    /**
     * ID of the service manager to which this service is attached with. This field is
     * not set during creation of service. This field will be set explicitly when
     * Service Manager is created successfully using this service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceManagerId() {
        return this.serviceManagerId;
    }

    /**
     * ID of the service manager to which this service is attached with. This field is
     * not set during creation of service. This field will be set explicitly when
     * Service Manager is created successfully using this service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceManagerId New value for the property.
     */
    public void setServiceManagerId(java.lang.String serviceManagerId) {
        this.serviceManagerId = serviceManagerId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_L2_BRIDGE}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_L3_ROUTED}</li>
     * <li> {@link com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_NSH}</li>
     * </ul> Transport Type of the service, which is the mechanism of redirecting the
     * traffic to the the partner appliance. Transport type is required if Service
     * caters to any functionality other than EPP and MPS.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getTransports() {
        return this.transports;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_L2_BRIDGE}</li> <li>
     * {@link com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_L3_ROUTED}</li>
     * <li> {@link com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_NSH}</li>
     * </ul> Transport Type of the service, which is the mechanism of redirecting the
     * traffic to the the partner appliance. Transport type is required if Service
     * caters to any functionality other than EPP and MPS.
     *
     * @param transports New value for the property.
     */
    public void setTransports(java.util.List<java.lang.String> transports) {
        this.transports = transports;
    }

    /**
     * Id which is unique to a vendor or partner for which the service is created.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVendorId() {
        return this.vendorId;
    }

    /**
     * Id which is unique to a vendor or partner for which the service is created.
     *
     * @param vendorId New value for the property.
     */
    public void setVendorId(java.lang.String vendorId) {
        this.vendorId = vendorId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.serviceDefinition;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("attachment_point",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.attachmentPoint, this._getType().getField("attachment_point")));
        structValue.setField("functionalities",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.functionalities, this._getType().getField("functionalities")));
        structValue.setField("implementations",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.implementations, this._getType().getField("implementations")));
        structValue.setField("on_failure_policy",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.onFailurePolicy, this._getType().getField("on_failure_policy")));
        structValue.setField("service_capability",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceCapability, this._getType().getField("service_capability")));
        structValue.setField("service_deployment_spec",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceDeploymentSpec, this._getType().getField("service_deployment_spec")));
        structValue.setField("service_manager_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceManagerId, this._getType().getField("service_manager_id")));
        structValue.setField("transports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transports, this._getType().getField("transports")));
        structValue.setField("vendor_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vendorId, this._getType().getField("vendor_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.serviceDefinition;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.serviceDefinition.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ServiceDefinition _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceDefinition(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ServiceDefinition _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceDefinition(structValue);
    }

    /**
     * Builder class for {@link ServiceDefinition}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_policy.model.Tag> tags;
        private java.util.List<java.lang.String> attachmentPoint;
        private java.util.List<java.lang.String> functionalities;
        private java.util.List<java.lang.String> implementations;
        private java.lang.String onFailurePolicy;
        private com.vmware.nsx_policy.model.ServiceCapability serviceCapability;
        private com.vmware.nsx_policy.model.ServiceDeploymentSpec serviceDeploymentSpec;
        private java.lang.String serviceManagerId;
        private java.util.List<java.lang.String> transports;
        private java.lang.String vendorId;

        /**
         * Constructor with parameters for the required properties of
         * {@link ServiceDefinition}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_TIER0_LR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_TIER1_LR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#ATTACHMENT_POINT_SERVICE_PLANE}</li>
         * </ul> The point at which the service is deployed/attached for redirecting the
         * traffic to the the partner appliance. Attachment Point is required if Service
         * caters to any functionality other than EPP and MPS.
         *
         * @param attachmentPoint New value for the property.
         */
        public Builder setAttachmentPoint(java.util.List<java.lang.String> attachmentPoint) {
            this.attachmentPoint = attachmentPoint;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_NG_FW}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_IDS_IPS}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_NET_MON}</li> <li>
         * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_HCX}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_BYOD}</li> <li>
         * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_EPP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_TLB}</li> <li>
         * {@link com.vmware.nsx_policy.model.ServiceDefinition#FUNCTIONALITIES_MPS}</li>
         * </ul> The capabilities provided by the services. Needs to be one or more of the
         * following | NG_FW - Next Generation Firewall | IDS_IPS - Intrusion Detection
         * System / Intrusion Prevention System | NET_MON - Network Monitoring | HCX -
         * Hybrid Cloud Exchange | BYOD - Bring Your Own Device | TLB - Transparent Load
         * Balancer | EPP - Endpoint Protection.(Third party AntiVirus partners using NXGI
         * should use this functionality for the service) | MPS - Malware Prevention
         * Solution
         *
         * @param functionalities New value for the property.
         */
        public Builder setFunctionalities(java.util.List<java.lang.String> functionalities) {
            this.functionalities = functionalities;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#IMPLEMENTATIONS_NORTH_SOUTH}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#IMPLEMENTATIONS_EAST_WEST}</li>
         * </ul> This indicates the insertion point of the service i.e whether the service
         * will be used to protect North-South or East-West traffic in the datacenter.
         *
         * @param implementations New value for the property.
         */
        public Builder setImplementations(java.util.List<java.lang.String> implementations) {
            this.implementations = implementations;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#ON_FAILURE_POLICY_ALLOW}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#ON_FAILURE_POLICY_BLOCK}</li>
         * </ul> Failure policy for the service tells datapath, the action to take i.e to
         * Allow or Block traffic during failure scenarios. For north-south
         * ServiceInsertion, failure policy in the service instance takes precedence. For
         * east-west ServiceInsertion, failure policy in the service chain takes
         * precedence. BLOCK is not supported for Endpoint protection (EPP) and MPS
         * functionality.
         *
         * @param onFailurePolicy New value for the property.
         */
        public Builder setOnFailurePolicy(java.lang.String onFailurePolicy) {
            this.onFailurePolicy = onFailurePolicy;
            return this;
        }

        /**
         *
         *
         * @param serviceCapability New value for the property.
         */
        public Builder setServiceCapability(com.vmware.nsx_policy.model.ServiceCapability serviceCapability) {
            this.serviceCapability = serviceCapability;
            return this;
        }

        /**
         *
         *
         * @param serviceDeploymentSpec New value for the property.
         */
        public Builder setServiceDeploymentSpec(com.vmware.nsx_policy.model.ServiceDeploymentSpec serviceDeploymentSpec) {
            this.serviceDeploymentSpec = serviceDeploymentSpec;
            return this;
        }

        /**
         * ID of the service manager to which this service is attached with. This field is
         * not set during creation of service. This field will be set explicitly when
         * Service Manager is created successfully using this service.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceManagerId New value for the property.
         */
        public Builder setServiceManagerId(java.lang.String serviceManagerId) {
            this.serviceManagerId = serviceManagerId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_L2_BRIDGE}</li> <li>
         * {@link com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_L3_ROUTED}</li>
         * <li> {@link com.vmware.nsx_policy.model.ServiceDefinition#TRANSPORTS_NSH}</li>
         * </ul> Transport Type of the service, which is the mechanism of redirecting the
         * traffic to the the partner appliance. Transport type is required if Service
         * caters to any functionality other than EPP and MPS.
         *
         * @param transports New value for the property.
         */
        public Builder setTransports(java.util.List<java.lang.String> transports) {
            this.transports = transports;
            return this;
        }

        /**
         * Id which is unique to a vendor or partner for which the service is created.
         *
         * @param vendorId New value for the property.
         */
        public Builder setVendorId(java.lang.String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public ServiceDefinition build() {
            ServiceDefinition result = new ServiceDefinition();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setAttachmentPoint(this.attachmentPoint);
            result.setFunctionalities(this.functionalities);
            result.setImplementations(this.implementations);
            result.setOnFailurePolicy(this.onFailurePolicy);
            result.setServiceCapability(this.serviceCapability);
            result.setServiceDeploymentSpec(this.serviceDeploymentSpec);
            result.setServiceManagerId(this.serviceManagerId);
            result.setTransports(this.transports);
            result.setVendorId(this.vendorId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("attachment_point", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("attachment_point",
                                                                                "attachmentPoint",
                                                                                "getAttachmentPoint",
                                                                                "setAttachmentPoint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("functionalities", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("functionalities",
                                                                                "functionalities",
                                                                                "getFunctionalities",
                                                                                "setFunctionalities");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("implementations", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("implementations",
                                                                                "implementations",
                                                                                "getImplementations",
                                                                                "setImplementations");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("on_failure_policy", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("on_failure_policy",
                                                                                "onFailurePolicy",
                                                                                "getOnFailurePolicy",
                                                                                "setOnFailurePolicy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_capability", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.serviceCapability; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_capability",
                                                                                "serviceCapability",
                                                                                "getServiceCapability",
                                                                                "setServiceCapability");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_deployment_spec", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.serviceDeploymentSpec; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_deployment_spec",
                                                                                "serviceDeploymentSpec",
                                                                                "getServiceDeploymentSpec",
                                                                                "setServiceDeploymentSpec");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_manager_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_manager_id",
                                                                                "serviceManagerId",
                                                                                "getServiceManagerId",
                                                                                "setServiceManagerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transports",
                                                                                "transports",
                                                                                "getTransports",
                                                                                "setTransports");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vendor_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vendor_id",
                                                                                "vendorId",
                                                                                "getVendorId",
                                                                                "setVendorId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.service_definition",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ServiceDefinition.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

