/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * IP and MAC assignment specification for Static IP List.
 */
public final class StaticIpMacListSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "StaticIpMacListSpec";

    private java.lang.String defaultGateway;

    private java.util.List<com.vmware.nsx_policy.model.IpMacPair> ipMacList;

    private java.lang.String subnetMask;

    private final java.lang.String resourceType = "StaticIpMacListSpec";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public StaticIpMacListSpec() {
    }

    protected StaticIpMacListSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Gateway IP format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultGateway() {
        return this.defaultGateway;
    }

    /**
     * Gateway IP format: ip
     *
     * @param defaultGateway New value for the property.
     */
    public void setDefaultGateway(java.lang.String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    /**
     * List of IPs and MACs for transport node host switch virtual tunnel endpoints
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.IpMacPair> getIpMacList() {
        return this.ipMacList;
    }

    /**
     * List of IPs and MACs for transport node host switch virtual tunnel endpoints
     *
     * @param ipMacList New value for the property.
     */
    public void setIpMacList(java.util.List<com.vmware.nsx_policy.model.IpMacPair> ipMacList) {
        this.ipMacList = ipMacList;
    }

    /**
     * Subnet mask format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubnetMask() {
        return this.subnetMask;
    }

    /**
     * Subnet mask format: ip
     *
     * @param subnetMask New value for the property.
     */
    public void setSubnetMask(java.lang.String subnetMask) {
        this.subnetMask = subnetMask;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.IpAssignmentSpec#RESOURCE_TYPE_STATICIPPOOLSPEC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.IpAssignmentSpec#RESOURCE_TYPE_STATICIPLISTSPEC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.IpAssignmentSpec#RESOURCE_TYPE_ASSIGNEDBYDHCP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.IpAssignmentSpec#RESOURCE_TYPE_STATICIPMACLISTSPEC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.IpAssignmentSpec#RESOURCE_TYPE_NONE}</li> </ul>
     * The value of this property is automatically populated to {@code "StaticIpMacListSpec"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.staticIpMacListSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("default_gateway",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultGateway, this._getType().getField("default_gateway")));
        structValue.setField("ip_mac_list",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipMacList, this._getType().getField("ip_mac_list")));
        structValue.setField("subnet_mask",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnetMask, this._getType().getField("subnet_mask")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.staticIpMacListSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.staticIpMacListSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static StaticIpMacListSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new StaticIpMacListSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static StaticIpMacListSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new StaticIpMacListSpec(structValue);
    }

    /**
     * Builder class for {@link StaticIpMacListSpec}.
     */
    public static final class Builder {
        private java.lang.String defaultGateway;
        private java.util.List<com.vmware.nsx_policy.model.IpMacPair> ipMacList;
        private java.lang.String subnetMask;

        /**
         * Constructor with parameters for the required properties of
         * {@link StaticIpMacListSpec}.
         */
        public Builder() {
        }

        /**
         * Gateway IP format: ip
         *
         * @param defaultGateway New value for the property.
         */
        public Builder setDefaultGateway(java.lang.String defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        /**
         * List of IPs and MACs for transport node host switch virtual tunnel endpoints
         *
         * @param ipMacList New value for the property.
         */
        public Builder setIpMacList(java.util.List<com.vmware.nsx_policy.model.IpMacPair> ipMacList) {
            this.ipMacList = ipMacList;
            return this;
        }

        /**
         * Subnet mask format: ip
         *
         * @param subnetMask New value for the property.
         */
        public Builder setSubnetMask(java.lang.String subnetMask) {
            this.subnetMask = subnetMask;
            return this;
        }

        public StaticIpMacListSpec build() {
            StaticIpMacListSpec result = new StaticIpMacListSpec();
            result.setDefaultGateway(this.defaultGateway);
            result.setIpMacList(this.ipMacList);
            result.setSubnetMask(this.subnetMask);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("default_gateway", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_gateway",
                                                                                "defaultGateway",
                                                                                "getDefaultGateway",
                                                                                "setDefaultGateway");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_mac_list", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ipMacPair; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_mac_list",
                                                                                "ipMacList",
                                                                                "getIpMacList",
                                                                                "setIpMacList");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnet_mask", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnet_mask",
                                                                                "subnetMask",
                                                                                "getSubnetMask",
                                                                                "setSubnetMask");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.static_ip_mac_list_spec",
                                                            fields,
                                                            com.vmware.nsx_policy.model.StaticIpMacListSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "StaticIpMacListSpec");
    }
}

