/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.aaa.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.aaa;

public interface RoleBindings extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.aaa.RoleBindingsTypes {

    /**
     * Delete the user/group's role assignment on CSP. If the path is provided then
     * deletes only the roles_for_paths that matches the path. If path is provided for
     * the last roles_for_paths then the whole role binding is deleted provided it is
     * not that of a local user.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type);

    /**
     * Delete the user/group's role assignment on CSP. If the path is provided then
     * deletes only the roles_for_paths that matches the path. If path is provided for
     * the last roles_for_paths then the whole role binding is deleted provided it is
     * not that of a local user.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete the user/group's role assignment on CSP. If the path is provided then
     * deletes only the roles_for_paths that matches the path. If path is provided for
     * the last roles_for_paths then the whole role binding is deleted provided it is
     * not that of a local user.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete the user/group's role assignment on CSP. If the path is provided then
     * deletes only the roles_for_paths that matches the path. If path is provided for
     * the last roles_for_paths then the whole role binding is deleted provided it is
     * not that of a local user.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get user/group's role information from CSP
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @return com.vmware.nsx_policy.model.RoleBinding
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.RoleBinding get(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type);

    /**
     * Get user/group's role information from CSP
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.RoleBinding
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.RoleBinding get(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get user/group's role information from CSP
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.RoleBinding
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.RoleBinding> asyncCallback);

    /**
     * Get user/group's role information from CSP
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.RoleBinding
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param bindingId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String bindingId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.RoleBinding> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get all users and groups with their roles from CSP. If the root_path is provided
     * then only return role bindings that start-with or are sub-trees of the provided
     * root path. Also filter the roles_for_paths such that only those roles_for_paths
     * appear that start-with or are sub-tree of the provided root path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @return com.vmware.nsx_policy.model.RoleBindingListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.RoleBindingListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type);

    /**
     * Get all users and groups with their roles from CSP. If the root_path is provided
     * then only return role bindings that start-with or are sub-trees of the provided
     * root path. Also filter the roles_for_paths such that only those roles_for_paths
     * appear that start-with or are sub-tree of the provided root path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.RoleBindingListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.RoleBindingListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get all users and groups with their roles from CSP. If the root_path is provided
     * then only return role bindings that start-with or are sub-trees of the provided
     * root path. Also filter the roles_for_paths such that only those roles_for_paths
     * appear that start-with or are sub-tree of the provided root path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.RoleBindingListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.RoleBindingListResult> asyncCallback);

    /**
     * Get all users and groups with their roles from CSP. If the root_path is provided
     * then only return role bindings that start-with or are sub-trees of the provided
     * root path. Also filter the roles_for_paths such that only those roles_for_paths
     * appear that start-with or are sub-tree of the provided root path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.RoleBindingListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param identitySourceId Identity source ID (optional)
     * @param identitySourceType Identity source type (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param name User/Group name (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param path Exact path of the context (optional)
     * @param role Role ID (optional)
     * @param rootPath Prefix path of the context (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.String identitySourceId, java.lang.String identitySourceType, java.lang.String includedFields, java.lang.String name, java.lang.Long pageSize, java.lang.String path, java.lang.String role, java.lang.String rootPath, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.RoleBindingListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
