/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.infra;

public interface ContextProfiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.infra.ContextProfilesTypes {

    /**
     * Deletes the specified Policy Context Profile. If the Policy Context Profile is
     * consumed in a firewall rule, it won't get deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId Policy Context Profile Id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param override Delete the locally overriden global object (optional, default to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, java.lang.Boolean force, java.lang.Boolean override);

    /**
     * Deletes the specified Policy Context Profile. If the Policy Context Profile is
     * consumed in a firewall rule, it won't get deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId Policy Context Profile Id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param override Delete the locally overriden global object (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, java.lang.Boolean force, java.lang.Boolean override, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified Policy Context Profile. If the Policy Context Profile is
     * consumed in a firewall rule, it won't get deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId Policy Context Profile Id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param override Delete the locally overriden global object (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, java.lang.Boolean force, java.lang.Boolean override, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified Policy Context Profile. If the Policy Context Profile is
     * consumed in a firewall rule, it won't get deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId Policy Context Profile Id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param override Delete the locally overriden global object (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, java.lang.Boolean force, java.lang.Boolean override, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get a single PolicyContextProfile by id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @return com.vmware.nsx_policy.model.PolicyContextProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyContextProfile get(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId);

    /**
     * Get a single PolicyContextProfile by id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyContextProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyContextProfile get(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get a single PolicyContextProfile by id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyContextProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyContextProfile> asyncCallback);

    /**
     * Get a single PolicyContextProfile by id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyContextProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyContextProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get all PolicyContextProfiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.PolicyContextProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyContextProfileListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get all PolicyContextProfiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyContextProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyContextProfileListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get all PolicyContextProfiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyContextProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyContextProfileListResult> asyncCallback);

    /**
     * Get all PolicyContextProfiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyContextProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyContextProfileListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override);

    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @return com.vmware.nsx_policy.model.PolicyContextProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyContextProfile update(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override);

    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyContextProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyContextProfile update(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyContextProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyContextProfile> asyncCallback);

    /**
     * Creates/Updates a PolicyContextProfile, which encapsulates attribute and
     * sub-attributes of network services. Rules for using attributes and
     * sub-attributes in single PolicyContextProfile 1. One type of attribute can't
     * have multiple occurrences. ( Eg. - Attribute type APP_ID can be used only once
     * per PolicyContextProfile.) 2. For specifying multiple values for an attribute,
     * provide them in an array. 3. If sub-attribtes are mentioned for an attribute,
     * then only single value is allowed for that attribute. 4. To get a list of
     * supported attributes and sub-attributes fire the following REST API GET
     * https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5. Do not
     * create context profile with \"custom_attributes\" id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyContextProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param contextProfileId (required)
     * @param policyContextProfile (required)
     * @param override Locally override the global object (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String contextProfileId, com.vmware.nsx_policy.model.PolicyContextProfile policyContextProfile, java.lang.Boolean override, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyContextProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
