/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.infra.tier_1s.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.infra.tier_1s;

public interface Segments extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.infra.tier_1s.SegmentsTypes {

    /**
     * Delete segment
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId);

    /**
     * Delete segment
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete segment
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete segment
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Force delete bypasses validations during segment deletion. This may result in an
     * inconsistent connectivity.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete0(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId);

    /**
     * Force delete bypasses validations during segment deletion. This may result in an
     * inconsistent connectivity.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete0(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Force delete bypasses validations during segment deletion. This may result in an
     * inconsistent connectivity.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete0(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Force delete bypasses validations during segment deletion. This may result in an
     * inconsistent connectivity.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete0(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete one or multiple DHCP lease(s) specified by IP and MAC under a Tier-1. If
     * there is a DHCP server running upon the given segment, or this segment is using
     * a DHCP server running in its connected Tier-1, the DHCP lease(s) which match
     * exactly the IP address and the MAC address will be deleted. If no such lease
     * matches, the deletion for this lease will be ignored. The DHCP lease to be
     * deleted will be removed by the system from both active and standby node. The
     * system will report error if the DHCP lease could not be removed from both nodes.
     * If the DHCP lease could not be removed on either node, please check the DHCP
     * server status. Once the DHCP server status is UP, please invoke the deletion API
     * again to ensure the lease gets deleted from both nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param dhcpDeleteLeases (required)
     * @param enforcementPointPath Enforcement point path (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void deletedhcpleases(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.DhcpDeleteLeases dhcpDeleteLeases, java.lang.String enforcementPointPath);

    /**
     * Delete one or multiple DHCP lease(s) specified by IP and MAC under a Tier-1. If
     * there is a DHCP server running upon the given segment, or this segment is using
     * a DHCP server running in its connected Tier-1, the DHCP lease(s) which match
     * exactly the IP address and the MAC address will be deleted. If no such lease
     * matches, the deletion for this lease will be ignored. The DHCP lease to be
     * deleted will be removed by the system from both active and standby node. The
     * system will report error if the DHCP lease could not be removed from both nodes.
     * If the DHCP lease could not be removed on either node, please check the DHCP
     * server status. Once the DHCP server status is UP, please invoke the deletion API
     * again to ensure the lease gets deleted from both nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param dhcpDeleteLeases (required)
     * @param enforcementPointPath Enforcement point path (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void deletedhcpleases(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.DhcpDeleteLeases dhcpDeleteLeases, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete one or multiple DHCP lease(s) specified by IP and MAC under a Tier-1. If
     * there is a DHCP server running upon the given segment, or this segment is using
     * a DHCP server running in its connected Tier-1, the DHCP lease(s) which match
     * exactly the IP address and the MAC address will be deleted. If no such lease
     * matches, the deletion for this lease will be ignored. The DHCP lease to be
     * deleted will be removed by the system from both active and standby node. The
     * system will report error if the DHCP lease could not be removed from both nodes.
     * If the DHCP lease could not be removed on either node, please check the DHCP
     * server status. Once the DHCP server status is UP, please invoke the deletion API
     * again to ensure the lease gets deleted from both nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param dhcpDeleteLeases (required)
     * @param enforcementPointPath Enforcement point path (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void deletedhcpleases(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.DhcpDeleteLeases dhcpDeleteLeases, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete one or multiple DHCP lease(s) specified by IP and MAC under a Tier-1. If
     * there is a DHCP server running upon the given segment, or this segment is using
     * a DHCP server running in its connected Tier-1, the DHCP lease(s) which match
     * exactly the IP address and the MAC address will be deleted. If no such lease
     * matches, the deletion for this lease will be ignored. The DHCP lease to be
     * deleted will be removed by the system from both active and standby node. The
     * system will report error if the DHCP lease could not be removed from both nodes.
     * If the DHCP lease could not be removed on either node, please check the DHCP
     * server status. Once the DHCP server status is UP, please invoke the deletion API
     * again to ensure the lease gets deleted from both nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param dhcpDeleteLeases (required)
     * @param enforcementPointPath Enforcement point path (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void deletedhcpleases(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.DhcpDeleteLeases dhcpDeleteLeases, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read segment Note: Extended Segment: Please note that old vpn path deprecated.
     * If user specify old l2vpn path in the \"l2_extension\" object in the PUT/PATCH
     * API payload, the path returned in the GET response payload may include the new
     * path instead of the deprecated l2vpn path. Both old and new l2vpn path refer to
     * same resource. there is no functional impact. Also note that l2vpn path included
     * in the error messages returned from validation may include the new VPN path
     * instead of the deprecated l2vpn path. Both new path and old vpn path refer to
     * same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @return com.vmware.nsx_policy.model.Segment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.Segment get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId);

    /**
     * Read segment Note: Extended Segment: Please note that old vpn path deprecated.
     * If user specify old l2vpn path in the \"l2_extension\" object in the PUT/PATCH
     * API payload, the path returned in the GET response payload may include the new
     * path instead of the deprecated l2vpn path. Both old and new l2vpn path refer to
     * same resource. there is no functional impact. Also note that l2vpn path included
     * in the error messages returned from validation may include the new VPN path
     * instead of the deprecated l2vpn path. Both new path and old vpn path refer to
     * same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.Segment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.Segment get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read segment Note: Extended Segment: Please note that old vpn path deprecated.
     * If user specify old l2vpn path in the \"l2_extension\" object in the PUT/PATCH
     * API payload, the path returned in the GET response payload may include the new
     * path instead of the deprecated l2vpn path. Both old and new l2vpn path refer to
     * same resource. there is no functional impact. Also note that l2vpn path included
     * in the error messages returned from validation may include the new VPN path
     * instead of the deprecated l2vpn path. Both new path and old vpn path refer to
     * same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.Segment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.Segment> asyncCallback);

    /**
     * Read segment Note: Extended Segment: Please note that old vpn path deprecated.
     * If user specify old l2vpn path in the \"l2_extension\" object in the PUT/PATCH
     * API payload, the path returned in the GET response payload may include the new
     * path instead of the deprecated l2vpn path. Both old and new l2vpn path refer to
     * same resource. there is no functional impact. Also note that l2vpn path included
     * in the error messages returned from validation may include the new VPN path
     * instead of the deprecated l2vpn path. Both new path and old vpn path refer to
     * same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.Segment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.Segment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     *
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentType Segment type (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.SegmentListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.SegmentListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentType, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     *
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentType Segment type (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SegmentListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.SegmentListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentType, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     *
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentType Segment type (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentType, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentListResult> asyncCallback);

    /**
     *
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentType Segment type (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentType, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, update the segment with specified attributes. Note: Extended
     * Segment: Please note that old vpn path deprecated. If user specify old l2vpn
     * path in the \"l2_extension\" object in the PATCH API payload, the path returned
     * in the GET response payload may include the new path instead of the deprecated
     * l2vpn path. Both old and new l2vpn path refer to same resource. there is no
     * functional impact. Also note that l2vpn path included in the Alarm, GPRR, error
     * messages returned from validation may include the new VPN path instead of the
     * deprecated l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment);

    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, update the segment with specified attributes. Note: Extended
     * Segment: Please note that old vpn path deprecated. If user specify old l2vpn
     * path in the \"l2_extension\" object in the PATCH API payload, the path returned
     * in the GET response payload may include the new path instead of the deprecated
     * l2vpn path. Both old and new l2vpn path refer to same resource. there is no
     * functional impact. Also note that l2vpn path included in the Alarm, GPRR, error
     * messages returned from validation may include the new VPN path instead of the
     * deprecated l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, update the segment with specified attributes. Note: Extended
     * Segment: Please note that old vpn path deprecated. If user specify old l2vpn
     * path in the \"l2_extension\" object in the PATCH API payload, the path returned
     * in the GET response payload may include the new path instead of the deprecated
     * l2vpn path. Both old and new l2vpn path refer to same resource. there is no
     * functional impact. Also note that l2vpn path included in the Alarm, GPRR, error
     * messages returned from validation may include the new VPN path instead of the
     * deprecated l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, update the segment with specified attributes. Note: Extended
     * Segment: Please note that old vpn path deprecated. If user specify old l2vpn
     * path in the \"l2_extension\" object in the PATCH API payload, the path returned
     * in the GET response payload may include the new path instead of the deprecated
     * l2vpn path. Both old and new l2vpn path refer to same resource. there is no
     * functional impact. Also note that l2vpn path included in the Alarm, GPRR, error
     * messages returned from validation may include the new VPN path instead of the
     * deprecated l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, replace the segment with this object. Note: Extended Segment:
     * Please note that old vpn path deprecated. If user specify old l2vpn path in the
     * \"l2_extension\" object in the PUT API payload, the path returned in the PUT/GET
     * response payload may include the new path instead of the deprecated l2vpn path.
     * Both old and new l2vpn path refer to same resource. there is no functional
     * impact. Also note that l2vpn path included in the Alarm, GPRR, error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @return com.vmware.nsx_policy.model.Segment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.Segment update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment);

    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, replace the segment with this object. Note: Extended Segment:
     * Please note that old vpn path deprecated. If user specify old l2vpn path in the
     * \"l2_extension\" object in the PUT API payload, the path returned in the PUT/GET
     * response payload may include the new path instead of the deprecated l2vpn path.
     * Both old and new l2vpn path refer to same resource. there is no functional
     * impact. Also note that l2vpn path included in the Alarm, GPRR, error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.Segment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.Segment update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, replace the segment with this object. Note: Extended Segment:
     * Please note that old vpn path deprecated. If user specify old l2vpn path in the
     * \"l2_extension\" object in the PUT API payload, the path returned in the PUT/GET
     * response payload may include the new path instead of the deprecated l2vpn path.
     * Both old and new l2vpn path refer to same resource. there is no functional
     * impact. Also note that l2vpn path included in the Alarm, GPRR, error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.Segment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.Segment> asyncCallback);

    /**
     * If segment with the segment-id is not already present, create a new segment. If
     * it already exists, replace the segment with this object. Note: Extended Segment:
     * Please note that old vpn path deprecated. If user specify old l2vpn path in the
     * \"l2_extension\" object in the PUT API payload, the path returned in the PUT/GET
     * response payload may include the new path instead of the deprecated l2vpn path.
     * Both old and new l2vpn path refer to same resource. there is no functional
     * impact. Also note that l2vpn path included in the Alarm, GPRR, error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * l2vpn path. Both new path and old vpn path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.Segment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param segment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, com.vmware.nsx_policy.model.Segment segment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.Segment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
