/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn;

import com.vmware.vapi.cis.authn.SamlTokenSecurityContext;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.security.SecurityUtil;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.saml.PrincipalId;
import com.vmware.vapi.saml.SamlToken;
import com.vmware.vapi.security.AuthenticationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SamlTokenAuthnHandler
implements AuthenticationHandler {
    private static final String INVALID_AUTHN_MSG = "Authentication data not found";
    public static final String SAML_TOKEN_KEY = "saml_token";
    public static final String ERROR_KEY = "saml_error";

    public void authenticate(ExecutionContext.SecurityContext ctx, AsyncHandle<AuthenticationHandler.AuthenticationResult> asyncHandle) {
        Validate.notNull((Object)ctx);
        Validate.notNull(asyncHandle);
        Map requestData = (Map)SecurityUtil.narrowType((Object)ctx.getProperty("security_processor_metadata"), Map.class);
        if (requestData == null) {
            asyncHandle.setError(new RuntimeException(INVALID_AUTHN_MSG));
            return;
        }
        SamlToken token = (SamlToken)SecurityUtil.narrowType(requestData.get(SAML_TOKEN_KEY), SamlToken.class);
        Exception error = (Exception)SecurityUtil.narrowType(requestData.get(ERROR_KEY), Exception.class);
        if (error != null || token == null) {
            asyncHandle.setError(new RuntimeException(INVALID_AUTHN_MSG, error));
            return;
        }
        asyncHandle.setResult((Object)new AuthnResultImpl(token));
    }

    public List<String> supportedAuthenticationSchemes() {
        return Collections.unmodifiableList(Arrays.asList("com.vmware.vapi.std.security.saml_hok_token", "com.vmware.vapi.std.security.saml_bearer_token"));
    }

    private class PrincipalIdImpl
    implements com.vmware.vapi.security.PrincipalId {
        private final String name;
        private final String domain;

        private PrincipalIdImpl(PrincipalId principal) {
            this.name = principal.getName();
            this.domain = principal.getDomain();
        }

        public String getName() {
            return this.name;
        }

        public String getDomain() {
            return this.domain;
        }
    }

    private final class AuthnResultImpl
    extends AuthenticationHandler.AuthenticationResult {
        private final com.vmware.vapi.security.PrincipalId subject;
        private final List<com.vmware.vapi.security.PrincipalId> groupList = new ArrayList<com.vmware.vapi.security.PrincipalId>();
        private final SamlToken token;

        private AuthnResultImpl(SamlToken token) {
            assert (token != null);
            this.subject = new PrincipalIdImpl(token.getSubject());
            for (PrincipalId group : token.getGroupList()) {
                this.groupList.add(new PrincipalIdImpl(group));
            }
            this.token = token;
        }

        public com.vmware.vapi.security.PrincipalId getUser() {
            return this.subject;
        }

        public List<com.vmware.vapi.security.PrincipalId> getGroups() {
            return this.groupList;
        }

        public ExecutionContext.SecurityContext getSecurityContext() {
            return new SamlTokenSecurityContext(this.token);
        }
    }
}

