/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn.json;

import com.vmware.vapi.cis.authn.json.JsonSignatureVerificationProcessor;
import com.vmware.vapi.cis.util.RefreshableCache;
import com.vmware.vapi.dsig.json.SignatureException;
import com.vmware.vapi.dsig.json.StsTrustChain;
import com.vmware.vapi.protocol.RequestProcessor;
import com.vmware.vapi.saml.exception.InvalidTokenException;
import java.security.cert.X509Certificate;
import java.util.Map;

public class RetryJsonSignatureVerificationProcessor
implements RequestProcessor {
    private final RefreshableCache<X509Certificate[]> certsCache;
    private RequestProcessor decoratedProcessor;

    public RetryJsonSignatureVerificationProcessor(StsTrustChain trustChain, long retryDelayMs) {
        this(trustChain, retryDelayMs, 600L);
    }

    public RetryJsonSignatureVerificationProcessor(StsTrustChain trustChain, long retryDelayMs, long clockToleranceSec) {
        this.certsCache = new RefreshableCache<X509Certificate[]>(() -> trustChain.getStsTrustChain(), retryDelayMs);
        this.decoratedProcessor = new JsonSignatureVerificationProcessor(new CacheStsTrustChain(), clockToleranceSec);
    }

    public RetryJsonSignatureVerificationProcessor(RefreshableCache<X509Certificate[]> trustChainCache) {
        this.certsCache = trustChainCache;
        this.decoratedProcessor = new JsonSignatureVerificationProcessor(new CacheStsTrustChain());
    }

    public byte[] process(byte[] requestBytes, Map<String, Object> metadata, RequestProcessor.Request request) {
        byte[] processed = this.decoratedProcessor.process(requestBytes, metadata, request);
        if (RetryJsonSignatureVerificationProcessor.isInvalidTokenExceptionPresent(metadata)) {
            processed = this.retry(requestBytes, metadata, request);
        }
        return processed;
    }

    private byte[] retry(byte[] requestBytes, Map<String, Object> metadata, RequestProcessor.Request request) {
        this.certsCache.refresh();
        this.clearError(metadata);
        byte[] processed = this.decoratedProcessor.process(requestBytes, metadata, request);
        return processed;
    }

    private void clearError(Map<String, Object> metadata) {
        Map<String, Object> securityMetadata = RetryJsonSignatureVerificationProcessor.getSecurityMetadata(metadata);
        if (securityMetadata != null) {
            securityMetadata.remove("saml_error");
        }
    }

    static boolean isInvalidTokenExceptionPresent(Map<String, Object> metadata) {
        Map<String, Object> securityProcMetadata = RetryJsonSignatureVerificationProcessor.getSecurityMetadata(metadata);
        if (securityProcMetadata == null) {
            return false;
        }
        Exception error = (Exception)securityProcMetadata.get("saml_error");
        return error instanceof SignatureException && error.getCause() instanceof InvalidTokenException;
    }

    private static Map<String, Object> getSecurityMetadata(Map<String, Object> metadata) {
        if (metadata == null) {
            return null;
        }
        Map securityProcMetadata = (Map)metadata.get("security_processor_metadata");
        return securityProcMetadata;
    }

    void setDecoratedProcessor(RequestProcessor decoratedProcessor) {
        this.decoratedProcessor = decoratedProcessor;
    }

    RequestProcessor getDecoratedProcessor() {
        return this.decoratedProcessor;
    }

    class CacheStsTrustChain
    implements StsTrustChain {
        CacheStsTrustChain() {
        }

        public X509Certificate[] getStsTrustChain() {
            return (X509Certificate[])RetryJsonSignatureVerificationProcessor.this.certsCache.get();
        }
    }
}

