/* ***************************************************************************
 * Copyright (c) 2020-2022 VMware, Inc. All rights reserved. -- VMware Confidential
 * ***************************************************************************/

package com.vmware.vapi.bindings;

import java.util.concurrent.*;
import java.util.function.*;

/**
 * This class exposes the {@link Future} and {@link CompletionStage}
 * abstractions for binding clients.
 * <p>
 * Clients can consume the result of operation invocations as traditional
 * blocking future or use it in event driven way through the {@link CompletionStage}.
 * <p>
 * This class delegates its functionality to {@link CompletableFuture}.
 * @param <T> The result type returned by the {@link CompletionStageFuture#get} methods
 * and the return type of various {@link CompletionStage} operations.
 */
public class CompletionStageFuture<T> implements CompletionStage<T>, Future<T> {
	private CompletableFuture<T> completableFuture;

	public CompletionStageFuture(CompletableFuture<T> future) {
		this.completableFuture = future;
	}

	@Override
	public boolean cancel(boolean mayInterruptIfRunning) {
		return this.completableFuture.cancel(mayInterruptIfRunning);
	}

	@Override
	public boolean isCancelled() {
		return this.completableFuture.isCancelled();
	}

	@Override
	public boolean isDone() {
		return this.completableFuture.isDone();
	}

	@Override
	public T get() throws InterruptedException, ExecutionException {
		return this.completableFuture.get();
	}

	@Override
	public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
		return this.completableFuture.get(timeout, unit);
	}

	@Override
	public <U> CompletionStage<U> thenApply(Function<? super T, ? extends U> fn) {
		return this.completableFuture.thenApply(fn);
	}

	@Override
	public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
		return this.completableFuture.thenApplyAsync(fn);
	}

	@Override
	public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
		return this.completableFuture.thenApplyAsync(fn, executor);
	}

	@Override
	public CompletionStage<Void> thenAccept(Consumer<? super T> action) {
		return this.completableFuture.thenAccept(action);
	}

	@Override
	public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action) {
		return this.completableFuture.thenAcceptAsync(action);
	}

	@Override
	public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
		return this.completableFuture.thenAcceptAsync(action, executor);
	}

	@Override
	public CompletionStage<Void> thenRun(Runnable action) {
		return this.completableFuture.thenRun(action);
	}

	@Override
	public CompletionStage<Void> thenRunAsync(Runnable action) {
		return this.completableFuture.thenRunAsync(action);
	}

	@Override
	public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
		return this.completableFuture.thenRunAsync(action, executor);
	}

	@Override
	public <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other,
			BiFunction<? super T, ? super U, ? extends V> fn) {
		return this.completableFuture.thenCombine(other, fn);
	}

	@Override
	public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other,
			BiFunction<? super T, ? super U, ? extends V> fn) {
		return this.completableFuture.thenCombineAsync(other, fn);
	}

	@Override
	public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other,
			BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
		return this.completableFuture.thenCombineAsync(other, fn, executor);
	}

	@Override
	public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other,
			BiConsumer<? super T, ? super U> action) {
		return this.completableFuture.thenAcceptBoth(other, action);
	}

	@Override
	public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other,
			BiConsumer<? super T, ? super U> action) {
		return this.completableFuture.thenAcceptBothAsync(other, action);
	}

	@Override
	public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other,
			BiConsumer<? super T, ? super U> action, Executor executor) {
		return this.completableFuture.thenAcceptBothAsync(other, action, executor);
	}

	@Override
	public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
		return this.completableFuture.runAfterBoth(other, action);
	}

	@Override
	public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
		return this.completableFuture.runAfterBothAsync(other, action);
	}

	@Override
	public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
		return this.completableFuture.runAfterBothAsync(other, action, executor);
	}

	@Override
	public <U> CompletionStage<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
		return this.completableFuture.applyToEither(other, fn);
	}

	@Override
	public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
		return this.completableFuture.applyToEitherAsync(other, fn);
	}

	@Override
	public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn,
			Executor executor) {
		return this.completableFuture.applyToEitherAsync(other, fn, executor);
	}

	@Override
	public CompletionStage<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
		return this.completableFuture.acceptEither(other, action);
	}

	@Override
	public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
		return this.completableFuture.acceptEitherAsync(other, action);
	}

	@Override
	public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action,
			Executor executor) {
		return this.completableFuture.acceptEitherAsync(other, action, executor);
	}

	@Override
	public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
		return this.completableFuture.runAfterEither(other, action);
	}

	@Override
	public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
		return this.completableFuture.runAfterEitherAsync(other, action);
	}

	@Override
	public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
		return this.completableFuture.runAfterEitherAsync(other, action, executor);
	}

	@Override
	public <U> CompletionStage<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
		return this.completableFuture.thenCompose(fn);
	}

	@Override
	public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
		return this.completableFuture.thenComposeAsync(fn);
	}

	@Override
	public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn,
			Executor executor) {
		return this.completableFuture.thenComposeAsync(fn, executor);
	}

	@Override
	public CompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
		return this.completableFuture.exceptionally(fn);
	}

	@Override
	public CompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
		return this.completableFuture.whenComplete(action);
	}

	@Override
	public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
		return this.completableFuture.whenCompleteAsync(action);
	}

	@Override
	public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
		return this.completableFuture.whenCompleteAsync(action, executor);
	}

	@Override
	public <U> CompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
		return this.completableFuture.handle(fn);
	}

	@Override
	public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
		return this.completableFuture.handleAsync(fn);
	}

	@Override
	public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
		return this.completableFuture.handleAsync(fn, executor);
	}

	/**
	 * Returns the {@link CompletableFuture} delegate used to
	 * implement this {@link CompletionStageFuture}.
	 *
	 * @return the {@link CompletableFuture}
	 */
	@Override
	public CompletableFuture<T> toCompletableFuture() {
		return this.completableFuture;
	}
}
