/* *********************************************************************************
 * Copyright (c) 2018, 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************************************/

package com.vmware.vapi.bindings;

import com.vmware.vapi.bindings.client.InvocationConfig;

/**
 * Describes the invoke methods of none task vAPI operation.
 * @param <T> return type of the operation.
 */
public interface Invocable<T> {
    /**
     * Asynchronous method. Result of the invocation will be
     * returned as a {@link CompletionStageFuture}.
     * Once the server returns a value the future will be completed.
     * If the operation invocation throws an exception then the {@link CompletionStageFuture} will complete exceptionally.
     * @return {@link CompletionStageFuture} which holds the result of the operation invocation.
     */
    public CompletionStageFuture<T> invoke();

    /**
     * Asynchronous method with {@link InvocationConfig}.
     * Result of the invocation will be returned as a {@link CompletionStageFuture}.
     * Once the server returns a value the future will be completed.
     * If the operation invocation throws an exception then the {@link CompletionStageFuture} will complete exceptionally.
     * @param invocationConfig used for the operation invocation.
     * @return {@link CompletionStageFuture} which holds the result of the operation invocation.
     */
    public CompletionStageFuture<T> invoke(InvocationConfig invocationConfig);
}
