/* **********************************************************
 * Copyright 2015 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings;

/**
 * Interface for vAPI client-side stub factories.
 */
public interface StubCreator {

    /**
     * Creates a stub for the specified interface.
     *
     * @param vapiIface <code>Class</code> representing a vAPI interface. not null
     * @return a stub instance for the specified vAPI interface
     */
    public <T extends Service> T createStub(Class<T> vapiIface);

    /**
     * Creates a stub for the specified interface.
     *
     * @param vapiIface <code>Class</code> representing a vAPI interface; must
     *                  not be <code>null</code>
     * @param config the stub's additional configuration
     * @return a stub instance for the specified vAPI interface
     */
    public <T extends Service> T createStub(Class<T> vapiIface,
                                            StubConfigurationBase config);
}
