/* *********************************************************************************
 * Copyright (c) 2018, 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************************************/

package com.vmware.vapi.bindings;

import com.vmware.vapi.bindings.client.InvocationConfig;

/**
 * Describes the invoke methods of <em>task</em> vAPI operations.
 * @param <T> return type of the operation.
 */
public interface TaskInvocable<T> extends Invocable<Task<T>>{
    /**
     * Asynchronous method. Result of the invocation will be
     * returned as a {@link CompletionStageFuture}.
     * Once the server returns a value the future will be completed.
     * The result of the invocation is a {@link Task} object which holds
     * taskId and return type of the operation.
     * @return {@link CompletionStageFuture} which holds {@link Task} object with the taskId of the operation invocation.
     */
    @Override
    public CompletionStageFuture<Task<T>> invoke();

    /**
     * Asynchronous method with {@link InvocationConfig}.
     * Result of the invocation will be returned as a {@link CompletionStageFuture}.
     * Once the server returns a value the future will be completed.
     * The result of the invocation is a {@link Task} object which holds
     * taskId and return type of the operation.
     * @param invocationConfig used for the operation invocation.
     * @return {@link CompletionStageFuture} which holds {@link Task} object with the taskId of the operation invocation.
     */
    @Override
    public CompletionStageFuture<Task<T>> invoke(InvocationConfig invocationConfig);
}
