/* **********************************************************
 * Copyright 2012, 2014, 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.bindings.server;

import com.vmware.vapi.core.ExecutionContext;

/**
 * Information about a method call in the server-side bindings.
 *
 * <p>
 * <i>Backward compatibility:</i> New methods might be added to this interface
 * in future versions of the framework.
 * </p>
 */
public interface InvocationContext {

    /**
     * @return  execution context associated with the method call
     */
    ExecutionContext getExecutionContext();

    /**
     * @return  if the invocation is a task invocation
     */
    boolean isTask();
}
