/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.type;

public class OptionalType implements Type {

    private final Type elementType;

    public OptionalType(Type elementType) {
        if (elementType == null) {
            throw new NullPointerException();
        }
        this.elementType = elementType;
    }

    public Type getElementType() {
        return elementType;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }
}
