/* **********************************************************
 * Copyright 2012, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.type;

import com.vmware.vapi.internal.util.Validate;

public class SetType implements Type {

    private final Type elementType;

    /**
     * Set type.
     *
     * <p>For the Set element one of the integer, ID, URI, string or enumeration
     * type is expected.
     *
     * @param elementType the set element type (required).
     * @throws IllegalArgumentException if the argument is null.
     */
    public SetType(Type elementType) {
        Validate.notNull(elementType);
        this.elementType = elementType;
    }

    public Type getElementType() {
        return elementType;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }
}
