/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.type;

/**
 * Reference to another type. Resolved on demand when the {@link #resolve()}
 * method is invoked. The main benefit of using a type reference instead of
 * direct pointer to the other type, is that the reference is resolved lazily
 * and thus is not affected by bootstrapping circular dependencies and who gets
 * loaded first.
 *
 * @param <T> <code>Type</code> for this reference target type
 */
public abstract class TypeReference<T extends Type> implements Type {

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    /**
     * Resolves the reference. Returns the actual type that this reference
     * points to.
     *
     * @return referred type
     */
    public abstract T resolve();

}
