/* **********************************************************
 * Copyright 2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.client.exception;

/**
 * Indicates error detected in the SSL subsystem of the transport protocol.
 * <p>
 * The exceptions translated to this one are:
 * <li> javax.net.ssl.SSLException
 */
public class SslException extends TransportProtocolException {

    private static final long serialVersionUID = 6643126255155085879L;

    public SslException() {
        super();
    }

    public SslException(String message) {
        super(message);
    }

    public SslException(String message, Throwable cause) {
        super(message, cause);
    }

    public SslException(Throwable cause) {
        super(cause);
    }
}