/* **********************************************************
 * Copyright 2011-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ApiProvider.java --
 *
 *      Client-facing interface that provides introspection and
 *      invocation operations for API interfaces.
 *
 *      This is the core 'protocol' used to communicate to a vAPI
 *      provider. These are the fundamental operations on which the
 *      RPC, and dispatcher are built.  Everything used as input or
 *      returned from these methods are intended to be data objects
 *      only, no logic, and should be directly translatable into a
 *      serialization IDL or spec.
 */

package com.vmware.vapi.core;

import com.vmware.vapi.data.DataValue;

/**
 * The <code>ApiProvider</code> interface provides interface and
 * method introspection and invocation operations for use by API
 * clients.
 */
public interface ApiProvider {

    /**
     * Invokes the specified operation using the provided input and
     * execution context.
     *
     * <p>Target method is identified by <code>serviceId</code> and
     * <code>operationId</code>.
     *
     * @param serviceId   identifier of the target service
     * @param operationId identifier of the target operation
     * @param input       operation input parameters
     * @param ctx         execution context for the invocation
     * @param asyncHandle handle used to asynchronously "return" the result
     *                    or error of the invocation
     */
    public void invoke(String serviceId,
                       String operationId,
                       DataValue input,
                       ExecutionContext ctx,
                       AsyncHandle<MethodResult> asyncHandle);
}
