/* **********************************************************
 * Copyright (c) 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.core;

/**
 * Represents an operation that accepts a single input. This is borrowed
 * semantic from Java 8 {@code java.util.function.Consumer} and provided here
 * for compatibility with Java 7.
 *
 * @param <T> input data type
 */
public interface Consumer<T> {
    /**
     * Performs the operation on the given input
     * @param item the input argument
     */
    void accept(T item);
}
