/* **********************************************************
 * Copyright 2013, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ErrorValueException.java --
 *
 *      Exception that contains an ErrorValue
 */

package com.vmware.vapi.core;

import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.util.Validate;

/**
 * Exception that contains an <code>ErrorValue</code>.
 */
public final class ErrorValueException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private final ErrorValue errorValue;

    public ErrorValueException(ErrorValue errorValue) {
        Validate.notNull(errorValue);
        this.errorValue = errorValue;
    }

    public ErrorValue getErrorValue() {
        return errorValue;
    }

    @Override
    public String toString() {
        return errorValue.toString();
    }

}
