/* **********************************************************
 * Copyright (c) 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.core;

import java.util.List;
import java.util.Map;

/**
 * HTTP response abstraction for REST API invocations.
 */
public interface HttpResponse {
    /**
     * Returns the status code of the HTTP response.
     *
     * @return the status code as {@code int}
     */
    public int getStatusCode();

    /**
     * Returns the values of for a particular header name.
     *
     * <p>If the header name appears multiple times in the HTTP response
     * list of all values for that header name will be returned.
     *
     * @param headerName the name of the HTTP header to read
     * @return list of header values; may be empty but will never
     * be {@code null}.
     */
    public List<String> getHeader(String headerName);

    /**
     * Returns all HTTP headers.
     *
     * @return map of header name to header values; may be empty but will never
     * be {@code null}.
     * @see #getHeader
     */
    public Map<String, List<String>> getHeaders();
}