/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.core;

import com.vmware.vapi.data.DataValue;

/**
 * Synchronous version of {@link ApiProvider}.
 */
public interface SyncApiProvider {

    /**
     * Invokes the specified operation using the provided input and
     * execution context.
     *
     * <p>Target method is identified by <code>serviceId</code> and
     * <code>operationId</code>.
     *
     * @param serviceId   identifier of the target service
     * @param operationId identifier of the target operation
     * @param input       operation input parameters
     * @param ctx         execution context for the invocation
     * @return            result of the method invocation
     */
    public MethodResult invoke(String serviceId,
                               String operationId,
                               DataValue input,
                               ExecutionContext ctx);
}
