/* **********************************************************
 * Copyright (c) 2012-2013, 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.data;

public final class BooleanValue implements DataValue {

    private static final long serialVersionUID = 1L;

    private final boolean value;

    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    private BooleanValue(boolean value) {
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.BOOLEAN;
    }

    public boolean getValue() {
        return this.value;
    }

    public static BooleanValue getInstance(boolean bool) {
        return (bool ? TRUE : FALSE);
    }

    @Override
    public String toString() {
        return Boolean.toString(value);
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BooleanValue copy() {
        return this;
    }

    /**
     * Preserve the single instance for {@code true}, {@code false} class invariant when
     * creating instances via <em>Java</em> deserialization.
     * @see java.io.Serializable
     *
     * @return the {@link #TRUE} or {@link #FALSE} instance of this class
     */
    Object readResolve() {
        return getInstance(this.value);
    }
}
