/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * DefinitionVisitor.java --
 *
 *      Interface for Visitor for DataDefinitions
 */

package com.vmware.vapi.data;

public interface DefinitionVisitor {
    public void visit(VoidDefinition def);

    public void visit(BooleanDefinition def);

    public void visit(IntegerDefinition def);

    public void visit(DoubleDefinition def);

    public void visit(StringDefinition def);

    public void visit(BlobDefinition def);

    public void visit(OptionalDefinition def);

    public void visit(ListDefinition def);

    public void visit(StructDefinition def);

    public void visit(OpaqueDefinition def);

    public void visit(SecretDefinition def);

    public void visit(StructRefDefinition def);

    public void visit(DynamicStructDefinition def);

    public void visit(AnyErrorDefinition def);
}
