/* **********************************************************
 * Copyright 2011-2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * DoubleDefinition.java --
 *
 *      Type definition for vAPI double built-in type
 */

package com.vmware.vapi.data;

public class DoubleDefinition extends DataDefinition {
    private static DoubleDefinition instance = new DoubleDefinition();

    private DoubleDefinition() {
    }

    public static DoubleDefinition getInstance() {
        return instance;
    }

    @Override
    public DataType getType() {
        return DataType.DOUBLE;
    }

    @Override
    public String toString() {
        return "Double";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}
