/* **********************************************************
 * Copyright 2011-2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * StringDefinition.java --
 *
 *      Type definition for vAPI string built-in type
 */

package com.vmware.vapi.data;

public class StringDefinition extends DataDefinition {
    private static StringDefinition instance = new StringDefinition();

    private StringDefinition() {
    }

    public static StringDefinition getInstance() {
        return instance;
    }

    public DataType getType() {
        return DataType.STRING;
    }

    @Override
    public String toString() {
        return "String";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}
