/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * StringValue.java --
 *
 *      Value of type string.
 */
package com.vmware.vapi.data;

import static com.vmware.vapi.MessageFactory.getMessage;

import com.vmware.vapi.CoreException;

/**
 * Value of type string.
 */
public final class StringValue implements DataValue {

    private static final long serialVersionUID = 1L;

    /** The actual string content of this StringValue. */
    private final String value;

    /**
     * Create a value with the specified string content.
     *
     * @param value string
     * @throws CoreException if the passed string is null
     */
    public StringValue(String value) {
        if (value == null) {
            throw new CoreException(getMessage("vapi.data.string.null.string"));
        }
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }

    /**
     * Returns the underlying string content. Will never be null.
     *
     * @return content
     */
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof StringValue) {
            StringValue str = (StringValue) o;
            return this.value.equals(str.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StringValue copy() {
        return this;
    }
}
