/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.dsig.json;

import java.util.HashMap;
import java.util.Map;

import com.vmware.vapi.core.ExecutionContext.SecurityContext;
import com.vmware.vapi.internal.security.SecurityContextConstants;
import com.vmware.vapi.protocol.RequestProcessor;
import com.vmware.vapi.security.StdSecuritySchemes;
import com.vmware.vapi.security.UserPassSecurityContext;

/**
 * {@link RequestProcessor} implementation for user and password authentication
 */
public final class JsonUserPassProcessor extends SecurityContextProcessor {

    @Override
    public boolean isSchemeSupported(String requestedScheme) {
        return requestedScheme.equalsIgnoreCase(StdSecuritySchemes.USER_PASS);
    }

    @Override
    public Map<String, Object> getSecurityContextProperties(SecurityContext ctx) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(SecurityContextConstants.SCHEME_ID_KEY,
                StdSecuritySchemes.USER_PASS);
        props.put(UserPassSecurityContext.USER_KEY, ctx.getProperty(
                UserPassSecurityContext.USER_KEY));
        props.put(UserPassSecurityContext.PASSWORD_KEY, ctx.getProperty(
                UserPassSecurityContext.PASSWORD_KEY));
        return props;
    }
}
