/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ClassLoaderUtil.java --
 *
 *      Class loading policy used to load vAPI services.
 */

package com.vmware.vapi.internal;

/**
 * Class loading policy used to load vAPI services.
 */
public class ClassLoaderUtil {

    /**
     * Returns class loader which should be used to load service classes (stubs,
     * skeletons, interfaces, etc.) by the runtime. Normally this is the context
     * class loader of the current thread. If the context class loader is null,
     * then the class loader which loaded this utility class is returned.
     *
     * @return class loader
     */
    public static ClassLoader getServiceClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        /*
         * The context class loader might be null in OSGi context.
         */
        if (loader == null) {
            loader = ClassLoaderUtil.class.getClassLoader();
        }
        return loader;
    }

}
