/* **********************************************************
 * Copyright 2013-2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * BindingConverterExceptionTranslator.java --
 *
 * Exception translator for the binding layer.
 */

package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.internal.common.exception.ExceptionTranslatorBase;
import com.vmware.vapi.client.exception.BindingsException;

public class BindingsExceptionTranslator extends ExceptionTranslatorBase {
    /**
     * Translate 3rd party exception to our own exception hierarchy of client
     * exceptions. The exception stacktrace is fixed as if it was created in the
     * calling method.
     *
     * @param e the exception to be translated
     * @return the translated exception
     */
    public static RuntimeException translate(Exception e) {
        if (e instanceof ConverterException || e instanceof ConstraintValidationException) {
            return fixStackTrace(new BindingsException(e.getMessage(), e));
        }

        // Unknown exception, don't translate
        if (e instanceof RuntimeException) {
            return (RuntimeException) e;
        }

        // TODO: doesn't seem like good solution, maybe here is a good case for
        // the InternalException...
        return new RuntimeException(e.getMessage(), e);
    }
}