/* **********************************************************************************
 * Copyright (c) 2018, 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************************************/

package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.convert.ConverterFactory;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;

/**
 * Abstract decorator class that implements {@link ConverterFactory} using a delegate.
 * All method implementations delegate to the decorated factory.
 * <p>
 * Derived classes inherit delegated converter factory behavior
 * and override only required methods.
 */
public abstract class DefaultDecoratorConverterFactory implements ConverterFactory {
    protected ConverterFactory delegate;

    /**
     * @param delegate converter factory which methods will be used as default behavior.
     * @throws IllegalArgumentException when delegate converter is null.
     */
    public DefaultDecoratorConverterFactory(ConverterFactory delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate converterFactory cannot be null.");
        }
        this.delegate = delegate;
    }

    @Override
    public UniTypeConverter<ErrorValue, AnyErrorType> getAnyErrorConverter() {
        return delegate.getAnyErrorConverter();
    }

    @Override
    public PrimitiveConverter<BlobValue> getBinaryConverter() {
        return delegate.getBinaryConverter();
    }

    @Override
    public PrimitiveConverter<BooleanValue> getBooleanConverter() {
        return delegate.getBooleanConverter();
    }

    @Override
    public PrimitiveConverter<StringValue> getDateTimeConverter() {
        return delegate.getDateTimeConverter();
    }

    @Override
    public PrimitiveConverter<DoubleValue> getDoubleConverter() {
        return delegate.getDoubleConverter();
    }

    @Override
    public UniTypeConverter<StructValue, DynamicStructType> getDynamicStructureConverter() {
        return delegate.getDynamicStructureConverter();
    }

    @Override
    public UniTypeConverter<StringValue, EnumType> getEnumConverter() {
        return delegate.getEnumConverter();
    }

    @Override
    public UniTypeConverter<ErrorValue, ErrorType> getErrorConverter() {
        return delegate.getErrorConverter();
    }

    @Override
    public PrimitiveConverter<StringValue> getIdConverter() {
        return delegate.getIdConverter();
    }

    @Override
    public PrimitiveConverter<IntegerValue> getIntegerConverter() {
        return delegate.getIntegerConverter();
    }

    @Override
    public UniTypeConverter<ListValue, ListType> getListConverter() {
        return delegate.getListConverter();
    }

    @Override
    public UniTypeConverter<DataValue, MapType> getMapConverter() {
        return delegate.getMapConverter();
    }

    @Override
    public PrimitiveConverter<DataValue> getOpaqueConverter() {
        return delegate.getOpaqueConverter();
    }

    @Override
    public UniTypeConverter<OptionalValue, OptionalType> getOptionalConverter() {
        return delegate.getOptionalConverter();
    }

    @Override
    public PrimitiveConverter<SecretValue> getSecretConverter() {
        return delegate.getSecretConverter();
    }

    @Override
    public UniTypeConverter<ListValue, SetType> getSetConverter() {
        return delegate.getSetConverter();
    }

    @Override
    public PrimitiveConverter<StringValue> getStringConverter() {
        return delegate.getStringConverter();
    }

    @Override
    public UniTypeConverter<StructValue, StructType> getStructConverter() {
        return delegate.getStructConverter();
    }

    @Override
    public PrimitiveConverter<StringValue> getUriConverter() {
        return delegate.getUriConverter();
    }

    @Override
    public PrimitiveConverter<VoidValue> getVoidConverter() {
        return delegate.getVoidConverter();
    }

}
