/* **********************************************************************************
 * Copyright (c) 2018, 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************************************/

package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vapi.internal.bindings.convert.impl.GregorianCalendarConverter;

/**
 * ConverterFactory which uses {@link ZonedDateTimeTimeConverter} as DateTimeConverter.
 */
public class ZonedDateTimeConverterFactory extends DefaultDecoratorConverterFactory {
    private final ZonedDateTimeTimeConverter dateConverter;

    /**
     * Creates ZonedDateTimeConverterFactory instance. Delegate's getDateTimeConverter method must return {@link GregorianCalendarConverter}.
     * @param delegate converter factory which methods will be used as default behavior.
     * @throws IllegalArgumentException when delegate.getDateTimeConverter() is not instance of {@link GregorianCalendarConverter}.
     */
    public ZonedDateTimeConverterFactory(DefaultConverterFactory delegate) throws IllegalArgumentException{
        super(delegate);
        PrimitiveConverter<StringValue> delegateDateTimeConverter = this.delegate.getDateTimeConverter();
        if (!(delegateDateTimeConverter instanceof GregorianCalendarConverter)) {
            throw new IllegalArgumentException("Delegated DateTimeConverter is not GregorianCalendarConverter");
        }
        this.dateConverter = new ZonedDateTimeTimeConverter((GregorianCalendarConverter) delegateDateTimeConverter);
    }

    @Override
    public PrimitiveConverter<StringValue> getDateTimeConverter() {
        return dateConverter;
    }

}
