/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * CharArraySecretConverter.java --
 *
 *      Convert secret type to char array
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert secret type to char array.
 */
public class CharArraySecretConverter implements PrimitiveConverter<SecretValue> {

    @Override
    public char[] fromValue(SecretValue value) {
        return value.getValue();
    }

    @Override
    public SecretValue toValue(Object primitiveBinding) {
        char[] bind = ConvertUtil.narrowType(primitiveBinding, char[].class);
        return new SecretValue(bind);
    }

}
