/* **********************************************************
 * Copyright (c) 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext;

public class ExtensibleStructConverter<V extends StructValue, T extends StructType>
        extends JavaClassStructConverter<V, T> {

    /**
     * Abstracts the extraction of fields from Java object. This is useful to
     * provide custom logic around converting value. For example replacing the
     * value of fields in localization.
     * <p/>
     * When no field replacement is needed the call can delegate to
     * {@link BindingsUtil#getStructureFieldValue(StaticStructure, StructType, String)}
     */
    public interface FieldValueExtractor {
        /**
         * Retrieves a field value from the structure.
         *
         * @param structure the structure to extract field from
         * @param fieldName name of a field of the structure
         * @param declaredType type definition
         * @param cc conversion contextual data
         * @return extracted field value
         * @throw ConverterException if the field cannot be retrieved
         */
        public Object extractFieldValue(StaticStructure struct,
                                        String fieldName,
                                        StructType declaredType,
                                        ConversionContext cc);
    }

    private final FieldValueExtractor fields;

    public ExtensibleStructConverter(Class<V> valueClass,
                                     Class<? extends Structure> typeClass,
                                     boolean skipUnsetOptionalFields,
                                     FieldValueExtractor fields) {
        super(valueClass, typeClass, skipUnsetOptionalFields);
        this.fields = fields;
    }

    @Override
    protected Object extractFieldValue(T declaredType,
                             StaticStructure struct,
                             String fieldName,
                             ConversionContext cc) {
        Object fieldBinding = fields
                .extractFieldValue(struct, fieldName, declaredType, cc);
        return fieldBinding;
    }

    // TODO consider adding extension point for converting DataValue to binding
}
