/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * JavaLangBooleanBooleanConverter.java --
 *
 *      Convert boolean type to java.lang.Boolean
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert boolean type to java.lang.Boolean.
 */
public final class JavaLangBooleanBooleanConverter implements
        PrimitiveConverter<BooleanValue> {

    @Override
    public Boolean fromValue(BooleanValue value) {
        return Boolean.valueOf(value.getValue());
    }

    @Override
    public BooleanValue toValue(Object primitiveBinding) {
        Boolean bind = ConvertUtil.narrowType(primitiveBinding, Boolean.class);
        return BooleanValue.getInstance(bind);
    }

}
