/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * JavaLangLongIntegerConverter.java --
 *
 *      Convert integer type to java.lang.Long
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert integer type to java.lang.Long.
 */
public final class JavaLangLongIntegerConverter implements
        PrimitiveConverter<IntegerValue> {

    @Override
    public Long fromValue(IntegerValue value) {
        return Long.valueOf(value.getValue());
    }

    @Override
    public IntegerValue toValue(Object primitiveBinding) {
        Long bind = ConvertUtil.narrowType(primitiveBinding, Long.class);
        return new IntegerValue(bind);
    }

}
