/* **********************************************************
 * Copyright (c) 2012-2013, 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * JavaUtilCalendarDateTimeConverter.java --
 *
 *      Convert DateTime type to java.util.Calendar
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;

import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.util.DateTimeConverter;
import com.vmware.vapi.internal.util.Rfc3339DateTimeConverter;

/**
 * {@link PrimitiveConverter} implementation for DateTime. Also see
 * {@link DateTimeConverter}
 * <p>
 * This class is obsolete and should not be used. Please use
 * {@link JavaUtilCalendarRfc3339DateTimeConverter}
 */
public final class JavaUtilCalendarDateTimeConverter implements
        GregorianCalendarConverter {

    private final Rfc3339DateTimeConverter converter =
            new Rfc3339DateTimeConverter();

    @Override
    public GregorianCalendar fromValue(StringValue value) {
        return converter.fromStringValue(value.getValue());
    }

    @Override
    public StringValue toValue(Object primitiveBinding) {
        Calendar calendar = ConvertUtil.narrowType(primitiveBinding,
                                                   Calendar.class);
        return new StringValue(converter.toStringValue(calendar));
    }
}
