/* **********************************************************
 * Copyright (c) 2012-2013, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * JavaUtilListListConverter.java --
 *
 *      Convert list type to java.util.List
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import java.util.ArrayList;
import java.util.List;

import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;

/**
 * Convert list type to java.util.List.
 */
public final class JavaUtilListListConverter implements
        UniTypeConverter<ListValue, ListType> {

    @Override
    public Object fromValue(ListValue value, ListType declaredType,
            TypeConverter typeConverter) {
        List<Object> binding = new ArrayList<Object>();
        Type elementType = declaredType.getElementType();
        for (DataValue elementVal : value) {
            Object elem = typeConverter.convertToJava(elementVal, elementType);
            binding.add(elem);
        }
        return binding;
    }

    @Override
    public DataValue toValue(Object binding,
                             ListType declaredType,
                             TypeConverter typeConverter,
                             ConversionContext cc) {
        @SuppressWarnings("unchecked")
        final List<Object> list = ConvertUtil.narrowType(binding, List.class);
        Type elementType = declaredType.getElementType();
        ListValue value = new ListValue();
        for (Object elem : list) {
            DataValue elemVal = typeConverter
                    .convertToVapi(elem, elementType, cc);
            value.add(elemVal);
        }
        return value;
    }

}
