/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * NullVoidConverter.java --
 *
 *      Convert void type to null
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert void type to null.
 */
public final class NullVoidConverter implements PrimitiveConverter<VoidValue> {

    @Override
    public Object fromValue(VoidValue value) {
        return null;
    }

    @Override
    public VoidValue toValue(Object primitiveBinding) {
        if (primitiveBinding != null) {
            throw new ConverterException(
                    "vapi.bindings.typeconverter.voiddef.expect.null",
                    primitiveBinding.getClass().getCanonicalName());
        }
        return VoidValue.getInstance();
    }

}
