/* **********************************************************
 * Copyright (c) 2015-2022 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.client;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.client.Configuration;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.protocol.ProtocolConnection;

/**
 * vAPI client protocol to be used to access API providers.
 *
 * <p>Implementing classes represent various supported protocols, e.g. REST or
 * JSOC-RPC.
 */
public interface Protocol {
    public static final String BIO_HTTP_CLIENT_MONICKER ="apache.bio.http.client";
    public static final String NIO_HTTP_CLIENT_MONICKER ="apache.nio.http.client";
    public static final String DEFAULT_REQUEST_CONFIG_MONICKER = "apache.http.request.config";
    public static final String VAPI_INTERFACE_MONICKER = "vapi.interface";
    public static final String VAPI_CONNECTION_POOL = "vapi.connection.pool";

    /**
     * Creates a {@code ProtocolConnection} which can be used to access the API
     * using this protocol.
     *
     * @param url API endpoint URL
     * @param config
     * @return connection to the target API {@code url}
     */
    ProtocolConnection getProtocolConnection(String url, Configuration config);

    enum ApiProviderCardinality {
        SINGLE,
        PER_STUB,
    }

    ApiProviderCardinality getApiProviderCardinality();

    <T extends Service> TypeConverter getTypeConverter(StubConfigurationBase stubConfig, Class<T> vapiIface);
}
