/* **********************************************************
 * Copyright (c) 2013-2014, 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.common.exception;

import java.util.Arrays;

import com.vmware.vapi.client.exception.ClientException;

public abstract class ExceptionTranslatorBase {
    /**
    * Hide details about the exception translator from the stack trace.
    */
   public static ClientException fixStackTrace(ClientException e) {
      StackTraceElement[] stackTrace = e.getStackTrace();
      String translatorClassName = stackTrace[0].getClassName();
      int framesToPop = 1;
      for (; framesToPop < stackTrace.length; framesToPop++) {
         if (!translatorClassName
               .equals(stackTrace[framesToPop].getClassName())) {
            break;
         }
      }

      StackTraceElement[] newStackTrace = Arrays
            .copyOfRange(stackTrace, framesToPop, stackTrace.length);
      e.setStackTrace(newStackTrace);

      return e;
   }
}
